/*
 * Decompiled with CFR 0.152.
 */
package org.kathrynhuxtable.maven.plugins.imageGenerator;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageGeneratorMojo
extends AbstractMojo {
    private File configFile;
    private String lookAndFeel;
    private File outputDirectory;
    private File savedConfigFile;
    private JPanel panel;

    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    public void setLookAndFeel(String lookAndFeel) {
        this.lookAndFeel = lookAndFeel;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setSavedConfigFile(File savedConfigFile) {
        this.savedConfigFile = savedConfigFile;
    }

    public void execute() throws MojoExecutionException {
        Map<String, ImageInfo> config = this.parseConfigFile(this.configFile, true);
        Map<String, ImageInfo> oldConfig = this.parseConfigFile(this.savedConfigFile, false);
        this.createOutputDirectoryIfNecessary();
        try {
            UIManager.setLookAndFeel(this.lookAndFeel);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException("Unable to set look and feel " + this.lookAndFeel, e);
        }
        this.panel = new JPanel();
        this.panel.setOpaque(true);
        this.generateImageFiles(config, oldConfig);
        this.copyConfigToOldConfig(this.configFile, this.savedConfigFile);
    }

    private void generateImageFiles(Map<String, ImageInfo> config, Map<String, ImageInfo> oldConfig) throws MojoExecutionException {
        for (String filename : config.keySet()) {
            ImageInfo info = config.get(filename);
            ImageInfo oldInfo = oldConfig.get(filename);
            if (oldInfo != null && info.equals(oldInfo)) continue;
            this.getLog().info((CharSequence)("Creating image file " + filename));
            this.drawImage(filename, info.className, info.width, info.height, info.panelWidth, info.panelHeight, info.args, info.properties);
        }
    }

    private void drawImage(String filename, String className, int width, int height, int panelWidth, int panelHeight, Object[] args, Map<String, Object> properties) throws MojoExecutionException {
        JComponent c = this.createSwingObject(className, args);
        for (String key : properties.keySet()) {
            c.putClientProperty(key, properties.get(key));
        }
        BufferedImage image = this.paintToBufferedImage(c, width, height, panelWidth, panelHeight);
        this.writeImageFile(filename, image);
    }

    private JComponent createSwingObject(String className, Object ... args) throws MojoExecutionException {
        try {
            Class<?> c = Class.forName(className);
            Class[] argClasses = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argClasses[i] = args[i].getClass();
            }
            Constructor<?> constructor = c.getConstructor(argClasses);
            if (constructor == null) {
                throw new MojoExecutionException("Failed to find the constructor for the class: " + className);
            }
            return (JComponent)constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to create the object " + className + "(" + args + ")", e);
        }
    }

    private BufferedImage paintToBufferedImage(JComponent c, int width, int height, int panelWidth, int panelHeight) {
        this.panel.removeAll();
        this.panel.setSize(panelWidth, panelHeight);
        this.panel.add(c);
        c.setBounds((panelWidth - width) / 2, (panelHeight - height) / 2, width, height);
        BufferedImage image = new BufferedImage(panelWidth, panelHeight, 2);
        Graphics2D g = image.createGraphics();
        this.panel.paint(g);
        return image;
    }

    private void writeImageFile(String filename, BufferedImage image) throws MojoExecutionException {
        File outputfile = new File(this.outputDirectory, filename + ".png");
        try {
            ImageIO.write((RenderedImage)image, "png", outputfile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error writing image file " + outputfile, (Exception)e);
        }
    }

    private Map<String, ImageInfo> parseConfigFile(File filename, boolean quitOnError) throws MojoExecutionException {
        HashMap<String, ImageInfo> list = new HashMap<String, ImageInfo>();
        InputStream configStream = this.openInputStream(filename, quitOnError);
        Document doc = null;
        if (configStream == null) {
            return list;
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(configStream);
        }
        catch (Exception e) {
            this.closeInputStream(configStream);
            if (quitOnError) {
                throw new MojoExecutionException("Unable to parse XML config file " + filename, e);
            }
            return list;
        }
        doc.getDocumentElement().normalize();
        NodeList nodeList = doc.getElementsByTagName("image");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node imageNode = nodeList.item(i);
            if (imageNode.getNodeType() != 1) continue;
            ImageInfo info = new ImageInfo();
            String imageFile = this.getImageInfo((Element)imageNode, info);
            list.put(imageFile, info);
        }
        this.closeInputStream(configStream);
        return list;
    }

    private InputStream openInputStream(File filename, boolean quitOnError) throws MojoExecutionException {
        try {
            return new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            if (quitOnError) {
                throw new MojoExecutionException("Unable to open file \"" + filename, (Exception)e);
            }
            return null;
        }
    }

    private void closeInputStream(InputStream stream) {
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void createOutputDirectoryIfNecessary() throws MojoExecutionException {
        if (this.outputDirectory.exists()) {
            if (!this.outputDirectory.isDirectory()) {
                throw new MojoExecutionException("Output directory \"" + this.outputDirectory + "\" exists, but is not a directory.");
            }
            if (!this.outputDirectory.canWrite()) {
                throw new MojoExecutionException("Output directory \"" + this.outputDirectory + "\" exists, but is not writable.");
            }
        } else if (!this.outputDirectory.mkdirs()) {
            throw new MojoExecutionException("Output directory \"" + this.outputDirectory + "\" could not be created.");
        }
    }

    private void copyConfigToOldConfig(File configFilename, File oldConfigFilename) throws MojoExecutionException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.openInputStream(configFilename, true)));
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(oldConfigFilename));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to open for writing the file " + oldConfigFilename, (Exception)e);
        }
        try {
            String line = null;
            while ((line = reader.readLine()) != null) {
                writer.write(line);
                writer.write("\n");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write " + oldConfigFilename, (Exception)e);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {}
        }
    }

    private String getImageInfo(Element imageElem, ImageInfo info) throws MojoExecutionException {
        Element argElem;
        Node node;
        int i;
        String filename = imageElem.getAttribute("file");
        String w = imageElem.getAttribute("width");
        String h = imageElem.getAttribute("height");
        String pw = imageElem.getAttribute("panelWidth");
        String ph = imageElem.getAttribute("panelHeight");
        if (pw.length() == 0) {
            pw = w;
        }
        if (ph.length() == 0) {
            ph = h;
        }
        info.className = imageElem.getAttribute("class");
        info.width = Integer.parseInt(w);
        info.height = Integer.parseInt(h);
        info.panelWidth = Integer.parseInt(pw);
        info.panelHeight = Integer.parseInt(ph);
        ArrayList<Object> argList = new ArrayList<Object>();
        NodeList nodeList = imageElem.getElementsByTagName("argument");
        for (i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            argElem = (Element)node;
            String type = argElem.getAttribute("type");
            String value = argElem.getAttribute("value");
            argList.add(this.parseObject(type, value));
        }
        info.args = argList.toArray();
        info.properties = new HashMap<String, Object>();
        nodeList = imageElem.getElementsByTagName("clientProperty");
        for (i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            argElem = (Element)node;
            String name = argElem.getAttribute("name");
            String type = argElem.getAttribute("type");
            String value = argElem.getAttribute("value");
            info.properties.put(name, this.parseObject(type, value));
        }
        info.args = argList.toArray();
        return filename;
    }

    private Object parseObject(String type, String value) throws MojoExecutionException {
        Object obj = null;
        if ("String".equals(type)) {
            obj = value;
        } else if ("Integer".equals(type)) {
            obj = Integer.parseInt(value);
        } else if ("Float".equals(type)) {
            obj = Float.valueOf(Float.parseFloat(value));
        } else if ("Double".equals(type)) {
            obj = Double.parseDouble(value);
        } else {
            throw new MojoExecutionException("Unknown argument type: " + type);
        }
        return obj;
    }

    public static class ImageInfo {
        String className;
        int width;
        int height;
        int panelWidth;
        int panelHeight;
        Object[] args;
        Map<String, Object> properties;

        public boolean equals(Object obj) {
            if (!(obj instanceof ImageInfo)) {
                return false;
            }
            ImageInfo other = (ImageInfo)obj;
            return this.className.equals(other.className) && this.width == other.width && this.height == other.height && this.panelWidth == other.panelWidth && this.panelHeight == other.panelHeight && this.argsEquals(other) && ((Object)this.properties).equals(other.properties);
        }

        private boolean argsEquals(ImageInfo other) {
            if (this.args.length != other.args.length) {
                return false;
            }
            for (int i = 0; i < this.args.length; ++i) {
                if (this.args[i].equals(other.args[i])) continue;
                return false;
            }
            return true;
        }
    }
}

