/*
 * Decompiled with CFR 0.152.
 */
package org.kebish.junit5;

import java.lang.reflect.Method;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.kebish.core.config.TestInfo;
import org.kebish.junit5.KebTest;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/kebish/junit5/KebAfterTest;", "Lorg/junit/jupiter/api/extension/AfterTestExecutionCallback;", "kebTest", "Lorg/kebish/junit5/KebTest;", "(Lorg/kebish/junit5/KebTest;)V", "afterTestExecution", "", "context", "Lorg/junit/jupiter/api/extension/ExtensionContext;", "constructReportPath", "", "keb-junit5"})
public final class KebAfterTest
implements AfterTestExecutionCallback {
    private final KebTest kebTest;

    public void afterTestExecution(@NotNull ExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Optional optional = context.getExecutionException();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"context.executionException");
        boolean failed = optional.isPresent();
        String reportPath = this.constructReportPath(context);
        TestInfo testInfo = new TestInfo(reportPath);
        if (failed) {
            this.kebTest.afterTestFail(testInfo);
        } else {
            this.kebTest.afterTestSuccess(testInfo);
        }
        this.kebTest.afterTest(testInfo);
        this.kebTest.finalizeTest();
    }

    private final String constructReportPath(ExtensionContext context) {
        Object t = context.getTestClass().get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"context.testClass.get()");
        Class testClass = (Class)t;
        Package package_ = testClass.getPackage();
        Intrinsics.checkNotNullExpressionValue((Object)package_, (String)"testClass.`package`");
        String string = package_.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"testClass.`package`.name");
        String packageDirs = StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null);
        String className = testClass.getSimpleName();
        Object t2 = context.getTestMethod().get();
        Intrinsics.checkNotNullExpressionValue(t2, (String)"context.testMethod.get()");
        String methodName = ((Method)t2).getName();
        return packageDirs + '/' + className + '.' + methodName + "()";
    }

    public KebAfterTest(@NotNull KebTest kebTest) {
        Intrinsics.checkNotNullParameter((Object)((Object)kebTest), (String)"kebTest");
        this.kebTest = kebTest;
    }
}

