/*
 * Decompiled with CFR 0.152.
 */
package org.keeber.imaging;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.XMPMetaFactory;
import com.adobe.xmp.options.SerializeOptions;
import com.github.jaiimageio.plugins.tiff.BaselineTIFFTagSet;
import com.github.jaiimageio.plugins.tiff.TIFFDirectory;
import com.github.jaiimageio.plugins.tiff.TIFFField;
import com.github.jaiimageio.plugins.tiff.TIFFImageWriteParam;
import com.github.jaiimageio.plugins.tiff.TIFFTag;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Arrays;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Image {
    private BufferedImage raster;
    private Type type;
    private XMPMeta xmp;
    private int res = 0;
    private Color background = Color.WHITE;
    private ICC_Profile profile = null;
    public edit edit = new edit();
    public write write = new write();

    private Image(BufferedImage raster, IIOMetadata metadata2, Type type) {
        this.raster = raster;
        this.type = type;
        this.init(metadata2);
    }

    public ICC_Profile getProfile() {
        return this.profile;
    }

    public Image setProfile(ICC_Profile profile) {
        this.profile = profile;
        return this;
    }

    public Image setProfile(byte[] profile) {
        this.profile = ICC_Profile.getInstance(profile);
        return this;
    }

    public Image clone() {
        return new Image(this.raster.getSubimage(0, 0, this.raster.getWidth(), this.raster.getHeight()), null, this.type).setXMP(this.xmp).setRes(this.res).setBackground(this.background);
    }

    public XMPMeta getXMP() {
        return this.xmp;
    }

    public Image setXMP(XMPMeta xmp) {
        this.xmp = xmp;
        return this;
    }

    public XMPMeta clearXMP() {
        this.xmp = XMPMetaFactory.create();
        return this.xmp;
    }

    public String printXMP() {
        try {
            return XMPMetaFactory.serializeToString(this.xmp, null);
        }
        catch (XMPException e) {
            return "Error serializing XMP [" + e.getLocalizedMessage() + "].";
        }
    }

    public Image removeAlpha() {
        return this.normalize(true);
    }

    public Image normalize(boolean removeAlpha) {
        BufferedImage tmp = new BufferedImage(this.raster.getWidth(), this.raster.getHeight(), removeAlpha || !this.raster.getColorModel().hasAlpha() ? 1 : 2);
        Graphics2D g = tmp.createGraphics();
        g.drawImage(this.raster, 0, 0, removeAlpha || !this.raster.getColorModel().hasAlpha() ? this.background : Constants.TRANSPARENT, null);
        g.dispose();
        this.raster = tmp;
        return this;
    }

    private Image edit(EditParams edits) {
        BufferedImage tmp = new BufferedImage(edits.canvasWidth, edits.canvasHeight, edits.flatten || !this.raster.getColorModel().hasAlpha() ? 1 : 2);
        Graphics2D g = tmp.createGraphics();
        g.setBackground(this.background);
        if (edits.flatten || tmp.getType() == 1) {
            g.clearRect(0, 0, tmp.getWidth(), tmp.getHeight());
        }
        g.drawImage(this.raster.getScaledInstance(edits.imageWidth, edits.imageHeight, 4), edits.offsetX, edits.offsetY, edits.imageWidth, edits.imageHeight, null);
        g.dispose();
        this.raster = tmp;
        return this;
    }

    public Color getBackground() {
        return this.background;
    }

    public Image setBackground(Color background) {
        this.background = background;
        return this;
    }

    public int getRes() {
        return this.res;
    }

    public Image setRes(int res) {
        this.res = res;
        return this;
    }

    private void init(IIOMetadata metadata2) {
        IIOMetadataNode root;
        String xmpData = null;
        if (this.type == Type.JPG) {
            root = (IIOMetadataNode)metadata2.getAsTree(this.type.id);
            IIOMetadataNode markerSequence = (IIOMetadataNode)root.getElementsByTagName("markerSequence").item(0);
            NodeList nodes = markerSequence.getElementsByTagName("unknown");
            for (int i = 0; i < nodes.getLength(); ++i) {
                byte[] b;
                if (((IIOMetadataNode)nodes.item(i)).getAttribute("MarkerTag").matches("APP1|225")) {
                    b = (byte[])((IIOMetadataNode)nodes.item(i)).getUserObject();
                    xmpData = new String(b, Constants.XMP_HEADER_SIZE, b.length - Constants.XMP_HEADER_SIZE);
                }
                if (!((IIOMetadataNode)nodes.item(i)).getAttribute("MarkerTag").matches("APP2|226")) continue;
                b = (byte[])((IIOMetadataNode)nodes.item(i)).getUserObject();
                b = Arrays.copyOfRange(b, 14, b.length);
                this.profile = ICC_Profile.getInstance(b);
            }
        }
        if (this.type == Type.PNG) {
            IIOMetadataNode r;
            root = (IIOMetadataNode)metadata2.getAsTree(this.type.id);
            NodeList nodes = root.getElementsByTagName("iTXtEntry");
            for (int i = 0; i < nodes.getLength(); ++i) {
                if (!((IIOMetadataNode)nodes.item(i)).getAttribute("keyword").equals(Constants.PNG_KEYWORD)) continue;
                xmpData = ((IIOMetadataNode)nodes.item(i)).getAttribute("text");
            }
            nodes = root.getElementsByTagName("pHYs");
            if (nodes.getLength() == 1 && (r = (IIOMetadataNode)nodes.item(0)).getAttribute("unitSpecifier").equals("meter")) {
                this.res = Math.round((float)Integer.parseInt(r.getAttribute("pixelsPerUnitXAxis")) * 0.0254f);
            }
            if (this.res == 0 && (nodes = (root = (IIOMetadataNode)metadata2.getAsTree("javax_imageio_1.0")).getElementsByTagName("HorizontalPixelSize")).getLength() == 1) {
                r = (IIOMetadataNode)nodes.item(0);
                this.res = (int)Math.round(25.4 * (double)Float.parseFloat(r.getAttribute("value")));
            }
        }
        if (this.type == Type.TIF || this.type == Type.JPG) {
            try {
                TIFFDirectory t = TIFFDirectory.createFromMetadata((IIOMetadata)metadata2);
                if (t.containsTIFFField(700)) {
                    xmpData = new String(t.getTIFFField(700).getAsBytes());
                }
                if (t.containsTIFFField(282)) {
                    long[] r = t.getTIFFField(282).getAsRational(0);
                    this.res = Math.floorDiv((int)r[0], (int)r[1]);
                    if (t.containsTIFFField(296) && t.getTIFFField(296).getAsChars()[0] == '\u0003') {
                        this.res = Math.round((float)this.res * 2.54f);
                    }
                }
                if (t.containsTIFFField(34675)) {
                    this.profile = ICC_Profile.getInstance(t.getTIFFField(34675).getAsBytes());
                }
            }
            catch (IIOInvalidTreeException iIOInvalidTreeException) {
                // empty catch block
            }
        }
        if (xmpData != null && xmpData.startsWith("<?xpacket begin")) {
            try {
                this.xmp = XMPMetaFactory.parseFromString(xmpData);
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
        this.xmp = this.xmp == null ? XMPMetaFactory.create() : this.xmp;
        this.res = this.res == 0 ? 72 : this.res;
    }

    public static class metadata {
        public static String nodeToString(Node node) {
            StringWriter sw = new StringWriter();
            try {
                Transformer t = TransformerFactory.newInstance().newTransformer();
                t.setOutputProperty("omit-xml-declaration", "yes");
                t.setOutputProperty("indent", "yes");
                t.transform(new DOMSource(node), new StreamResult(sw));
            }
            catch (TransformerException te) {
                System.out.println("nodeToString Transformer Exception");
            }
            return sw.toString();
        }

        public static XMPMeta newXMPMeta() {
            return XMPMetaFactory.create();
        }

        public static void registerNS(String namespaceURI, String suggestedPrefix) throws XMPException {
            XMPMetaFactory.getSchemaRegistry().registerNamespace(namespaceURI, suggestedPrefix);
        }
    }

    public static class read {
        public static Image from(InputStream is, Type type) throws IOException {
            ImageReader reader = ImageIO.getImageReadersByFormatName(type.fm).next();
            reader.setInput(ImageIO.createImageInputStream(is), true, false);
            return new Image(reader.read(0), reader.getImageMetadata(0), type);
        }
    }

    private class EditParams {
        private int canvasWidth;
        private int canvasHeight;
        private int offsetX;
        private int offsetY;
        private int imageWidth;
        private int imageHeight;
        private boolean flatten = false;

        private EditParams() {
        }

        public EditParams longestSide(int length) {
            this.offsetX = 0;
            this.offsetY = 0;
            float scale = 1.0f * (float)length / (float)Math.max(Image.this.raster.getWidth(), Image.this.raster.getHeight());
            this.canvasWidth = this.imageWidth = Math.round(scale * (float)Image.this.raster.getWidth());
            this.canvasHeight = this.imageHeight = Math.round(scale * (float)Image.this.raster.getHeight());
            return this;
        }

        public EditParams place(int canvasWidth, int canvasHeight) {
            this.canvasWidth = canvasWidth;
            this.canvasHeight = canvasHeight;
            float scale = Math.min(1.0f * (float)canvasWidth / (float)Image.this.raster.getWidth(), 1.0f * (float)canvasHeight / (float)Image.this.raster.getHeight());
            this.imageWidth = Math.round(scale * (float)Image.this.raster.getWidth());
            this.imageHeight = Math.round(scale * (float)Image.this.raster.getHeight());
            this.offsetX = (canvasWidth - this.imageWidth) / 2;
            this.offsetY = (canvasHeight - this.imageHeight) / 2;
            return this;
        }
    }

    public class write {
        public void to(OutputStream os, Type otype) throws IOException {
            Image.this.write.to(os, otype, Image.this.xmp, false);
        }

        public void to(OutputStream os, Type otype, boolean flatten) throws IOException {
            Image.this.write.to(os, otype, Image.this.xmp, flatten);
        }

        public void to(OutputStream os, Type oType, XMPMeta oXmp, boolean flatten) throws IOException {
            IIOMetadataNode root;
            byte[] profileBytes;
            byte[] xmpBytes;
            ImageWriter writer = ImageIO.getImageWritersByFormatName(oType.fm).next();
            BufferedImage oRaster = Image.this.raster;
            if (oRaster.getColorModel().hasAlpha() && (flatten || oType == Type.JPG)) {
                oRaster = new BufferedImage(Image.this.raster.getWidth(), Image.this.raster.getHeight(), 1);
                Graphics2D g = oRaster.createGraphics();
                g.drawImage(Image.this.raster, 0, 0, Image.this.background, null);
                g.dispose();
            }
            ImageWriteParam p = writer.getDefaultWriteParam();
            IIOMetadata m = writer.getDefaultImageMetadata(new ImageTypeSpecifier(oRaster), null);
            try {
                xmpBytes = XMPMetaFactory.serializeToBuffer(oXmp, Constants.SERIALIZE_OPTIONS);
            }
            catch (XMPException e) {
                throw new IOException("Failed to serialize XMP[" + e.getLocalizedMessage() + "].", e);
            }
            byte[] byArray = profileBytes = Image.this.profile == null ? new byte[]{} : Image.this.profile.getData();
            if (oType == Type.JPG) {
                IIOMetadataNode app0JFIF;
                IIOMetadataNode jpegVariety;
                NodeList ch;
                root = (IIOMetadataNode)m.getAsTree(oType.id);
                IIOMetadataNode markerSequence = (IIOMetadataNode)root.getElementsByTagName("markerSequence").item(0);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                bos.write("http://ns.adobe.com/xap/1.0/\u0000".getBytes());
                bos.write(xmpBytes);
                IIOMetadataNode exif = new IIOMetadataNode("unknown");
                exif.setAttribute("MarkerTag", String.valueOf(225));
                exif.setUserObject(bos.toByteArray());
                markerSequence.appendChild(exif);
                if (profileBytes.length > 0) {
                    bos = new ByteArrayOutputStream();
                    bos.write("ICC_PROFILE\u0000".getBytes());
                    bos.write("\u0001\u0001".getBytes());
                    bos.write(profileBytes);
                    IIOMetadataNode icc = new IIOMetadataNode("unknown");
                    icc.setAttribute("MarkerTag", String.valueOf(226));
                    icc.setUserObject(bos.toByteArray());
                    markerSequence.appendChild(icc);
                }
                if ((ch = root.getElementsByTagName("JPEGvariety")).getLength() > 0) {
                    jpegVariety = (IIOMetadataNode)ch.item(0);
                } else {
                    jpegVariety = new IIOMetadataNode("JPEGvariety");
                    root.appendChild(jpegVariety);
                }
                ch = jpegVariety.getElementsByTagName("app0JFIF");
                if (ch.getLength() > 0) {
                    app0JFIF = (IIOMetadataNode)ch.item(0);
                } else {
                    app0JFIF = new IIOMetadataNode("app0JFIF");
                    jpegVariety.appendChild(app0JFIF);
                }
                app0JFIF.setAttribute("majorVersion", "1");
                app0JFIF.setAttribute("minorVersion", "2");
                app0JFIF.setAttribute("thumbWidth", "0");
                app0JFIF.setAttribute("thumbHeight", "0");
                app0JFIF.setAttribute("resUnits", "1");
                app0JFIF.setAttribute("Xdensity", String.valueOf(Image.this.res));
                app0JFIF.setAttribute("Ydensity", String.valueOf(Image.this.res));
                m.setFromTree(oType.id, root);
            }
            if (oType == Type.TIF) {
                TIFFDirectory t = TIFFDirectory.createFromMetadata((IIOMetadata)m);
                t.addTIFFField(new TIFFField(new TIFFTag("xmp", 700, 1), 1, xmpBytes.length, (Object)xmpBytes));
                t.addTIFFField(new TIFFField(Constants.BASE.getTag(282), 5, 1, (Object)new long[][]{{Image.this.res, 1L}}));
                t.addTIFFField(new TIFFField(Constants.BASE.getTag(283), 5, 1, (Object)new long[][]{{Image.this.res, 1L}}));
                t.addTIFFField(new TIFFField(Constants.BASE.getTag(296), 3, 1, (Object)new char[]{'\u0002'}));
                if (profileBytes.length > 0) {
                    t.addTIFFField(new TIFFField(Constants.BASE.getTag(34675), 1, profileBytes.length, (Object)profileBytes));
                }
                m = t.getAsMetadata();
                TIFFImageWriteParam tp = (TIFFImageWriteParam)p;
                tp.setCompressionMode(2);
                tp.setCompressionType("LZW");
            }
            if (oType == Type.PNG) {
                root = (IIOMetadataNode)m.getAsTree(oType.id);
                IIOMetadataNode t = new IIOMetadataNode("iTXt");
                root.appendChild(t);
                IIOMetadataNode x = new IIOMetadataNode("iTXtEntry");
                t.appendChild(x);
                x.setAttribute("keyword", Constants.PNG_KEYWORD);
                x.setAttribute("compressionMethod", "0");
                x.setAttribute("compressionFlag", "FALSE");
                x.setAttribute("languageTag", "");
                x.setAttribute("translatedKeyword", "");
                x.setAttribute("text", new String(xmpBytes));
                m.mergeTree(oType.id, root);
                root = (IIOMetadataNode)m.getAsTree("javax_imageio_1.0");
                IIOMetadataNode horiz = new IIOMetadataNode("HorizontalPixelSize");
                horiz.setAttribute("value", Double.toString((double)Image.this.res / 25.4));
                IIOMetadataNode vert = new IIOMetadataNode("VerticalPixelSize");
                vert.setAttribute("value", Double.toString((double)Image.this.res / 25.4));
                IIOMetadataNode dim = new IIOMetadataNode("Dimension");
                dim.appendChild(horiz);
                dim.appendChild(vert);
                root.appendChild(dim);
                root = (IIOMetadataNode)m.getAsTree("javax_imageio_1.0");
                IIOMetadataNode iccp = new IIOMetadataNode("iCCP");
                iccp.setUserObject(profileBytes);
                root.appendChild(iccp);
                m.mergeTree("javax_imageio_1.0", root);
            }
            File tmp = File.createTempFile("JImage", "." + oType.getExtention());
            tmp.deleteOnExit();
            writer.setOutput(ImageIO.createImageOutputStream(tmp));
            writer.write(null, new IIOImage(oRaster, null, m), p);
            writer.dispose();
            this.copy(new FileInputStream(tmp), os);
            tmp.delete();
        }

        private void copy(InputStream is, OutputStream os) throws IOException {
            int len;
            byte[] buffer = new byte[8192];
            while ((len = is.read(buffer)) > 0) {
                os.write(buffer, 0, len);
            }
            os.flush();
            is.close();
            os.close();
        }
    }

    public class edit {
        public Image longestSide(int length) {
            return Image.this.edit(new EditParams().longestSide(length));
        }

        public Image place(int canvasWidth, int canvasHeight) {
            return Image.this.edit(new EditParams().place(canvasWidth, canvasHeight));
        }
    }

    public static enum Type {
        TIF("tif", "com_sun_media_imageio_plugins_tiff_image_1.0", "tif"),
        JPG("jpg", "javax_imageio_jpeg_image_1.0", "jpg"),
        PNG("png", "javax_imageio_png_1.0", "png");

        private String fm;
        private String id;
        private String ex;

        private Type(String format, String id, String ext) {
            this.fm = format;
            this.id = id;
            this.ex = ext;
        }

        public String getExtention() {
            return this.ex;
        }
    }

    private static class Constants {
        public static Color TRANSPARENT = new Color(0xFFFFFF, true);
        public static final String XMP_PACKET_START = "<?xpacket begin";
        public static final int ICC_HEADER_SIZE = 14;
        private static int XMP_HEADER_SIZE = 29;
        private static SerializeOptions SERIALIZE_OPTIONS = new SerializeOptions().setUseCompactFormat(true);
        private static BaselineTIFFTagSet BASE = BaselineTIFFTagSet.getInstance();
        private static String PNG_KEYWORD = "XML:com.adobe.xmp";

        private Constants() {
        }
    }
}

