/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteBuffer {
    private byte[] buffer;
    private int length;
    private String encoding = null;

    public ByteBuffer(int initialCapacity) {
        this.buffer = new byte[initialCapacity];
        this.length = 0;
    }

    public ByteBuffer(byte[] buffer) {
        this.buffer = buffer;
        this.length = buffer.length;
    }

    public ByteBuffer(byte[] buffer, int length) {
        if (length > buffer.length) {
            throw new ArrayIndexOutOfBoundsException("Valid length exceeds the buffer length.");
        }
        this.buffer = buffer;
        this.length = length;
    }

    public ByteBuffer(InputStream in) throws IOException {
        int read2;
        int chunk = 16384;
        this.length = 0;
        this.buffer = new byte[chunk];
        while ((read2 = in.read(this.buffer, this.length, chunk)) > 0) {
            this.length += read2;
            if (read2 != chunk) break;
            this.ensureCapacity(this.length + chunk);
        }
    }

    public ByteBuffer(byte[] buffer, int offset, int length) {
        if (length > buffer.length - offset) {
            throw new ArrayIndexOutOfBoundsException("Valid length exceeds the buffer length.");
        }
        this.buffer = new byte[length];
        System.arraycopy(buffer, offset, this.buffer, 0, length);
        this.length = length;
    }

    public InputStream getByteStream() {
        return new ByteArrayInputStream(this.buffer, 0, this.length);
    }

    public int length() {
        return this.length;
    }

    public byte byteAt(int index) {
        if (index < this.length) {
            return this.buffer[index];
        }
        throw new IndexOutOfBoundsException("The index exceeds the valid buffer area");
    }

    public int charAt(int index) {
        if (index < this.length) {
            return this.buffer[index] & 0xFF;
        }
        throw new IndexOutOfBoundsException("The index exceeds the valid buffer area");
    }

    public void append(byte b) {
        this.ensureCapacity(this.length + 1);
        this.buffer[this.length++] = b;
    }

    public void append(byte[] bytes, int offset, int len) {
        this.ensureCapacity(this.length + len);
        System.arraycopy(bytes, offset, this.buffer, this.length, len);
        this.length += len;
    }

    public void append(byte[] bytes) {
        this.append(bytes, 0, bytes.length);
    }

    public void append(ByteBuffer anotherBuffer) {
        this.append(anotherBuffer.buffer, 0, anotherBuffer.length);
    }

    public String getEncoding() {
        if (this.encoding == null) {
            this.encoding = this.length < 2 ? "UTF-8" : (this.buffer[0] == 0 ? (this.length < 4 || this.buffer[1] != 0 ? "UTF-16BE" : ((this.buffer[2] & 0xFF) == 254 && (this.buffer[3] & 0xFF) == 255 ? "UTF-32BE" : "UTF-32")) : ((this.buffer[0] & 0xFF) < 128 ? (this.buffer[1] != 0 ? "UTF-8" : (this.length < 4 || this.buffer[2] != 0 ? "UTF-16LE" : "UTF-32LE")) : ((this.buffer[0] & 0xFF) == 239 ? "UTF-8" : ((this.buffer[0] & 0xFF) == 254 ? "UTF-16" : (this.length < 4 || this.buffer[2] != 0 ? "UTF-16" : "UTF-32")))));
        }
        return this.encoding;
    }

    private void ensureCapacity(int requestedLength) {
        if (requestedLength > this.buffer.length) {
            byte[] oldBuf = this.buffer;
            this.buffer = new byte[oldBuf.length * 2];
            System.arraycopy(oldBuf, 0, this.buffer, 0, oldBuf.length);
        }
    }
}

