/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.cli;

import java.util.ArrayList;
import java.util.List;
import org.kendar.cli.CommandOptions;
import org.kendar.cli.HelpLine;
import org.kendar.cli.MainArg;

public class CommandParser {
    private final CommandOptions options;
    private List<MainArg> mainArgs;
    private boolean printedHelp = false;

    public CommandParser(CommandOptions options) {
        this.options = options;
    }

    public CommandOptions getOptions() {
        return this.options;
    }

    public List<MainArg> getMainArgs() {
        return this.mainArgs;
    }

    private void buildArgs(String[] args) {
        this.mainArgs = new ArrayList<MainArg>();
        block0: for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith("-")) continue;
            String name = arg.substring(1);
            MainArg mainArg = new MainArg(name.toLowerCase());
            this.mainArgs.add(mainArg);
            ++i;
            while (i < args.length) {
                String arg2 = args[i];
                if (arg2.startsWith("-")) {
                    --i;
                    continue block0;
                }
                mainArg.addValue(arg2);
                ++i;
            }
        }
    }

    public void parse(String[] args) {
        try {
            this.buildArgs(args);
            this.options.parse(this.mainArgs, false);
            if (!this.mainArgs.isEmpty()) {
                this.printHelp();
            }
        }
        finally {
            if (!this.mainArgs.isEmpty()) {
                this.printHelp();
            }
        }
    }

    public void parseIgnoreMissing(String[] args) {
        this.buildArgs(args);
        this.options.parse(this.mainArgs, true);
    }

    public boolean hasOption(String id) {
        return this.options.hasOption(id);
    }

    public String getOptionValue(String id) {
        return this.getOptionValue(id, null);
    }

    public String getOptionValue(String id, String defaultValue) {
        List<String> v = this.options.getOptionValues(id);
        if (v == null || v.isEmpty()) {
            return defaultValue;
        }
        return v.get(0);
    }

    public List<String> getOptionValues(String id, String ... defaultValues) {
        List<String> v = this.options.getOptionValues(id);
        if (v == null || v.isEmpty()) {
            return new ArrayList<String>(List.of(defaultValues));
        }
        return v;
    }

    public void printHelp() {
        if (this.printedHelp) {
            return;
        }
        this.printedHelp = true;
        String toPrint = this.buildHelp();
        System.out.println(toPrint);
    }

    public String buildHelp() {
        ArrayList<HelpLine> result = new ArrayList<HelpLine>();
        StringBuilder toPrint = new StringBuilder();
        if (this.options.getDescription() != null) {
            result.add(new HelpLine(this.options.getDescription(), 0));
        }
        int level = 0;
        this.options.printHelp(result, level);
        int maxShort = 0;
        int maxLong = 0;
        for (HelpLine item : result) {
            if (item.getShortCommand() != null) {
                maxShort = Math.max(maxShort, item.getLevel() * 2 + item.getShortCommand().length());
            } else {
                item.setShortCommand("");
            }
            if (item.getLongCommand() != null) {
                maxLong = Math.max(maxLong, item.getLongCommand().length());
            } else {
                item.setLongCommand("");
            }
            if (item.getDescription() != null) continue;
            item.setDescription("");
        }
        StringBuilder sbShort = new StringBuilder();
        sbShort.append(" ".repeat(maxShort));
        StringBuilder sbLong = new StringBuilder();
        sbLong.append(" ".repeat(maxLong));
        int max = 130 - maxLong - maxShort - 3;
        boolean firstLine = true;
        for (HelpLine item : result) {
            StringBuilder levelSpace = new StringBuilder();
            levelSpace.append("  ".repeat(Math.max(0, item.getLevel())));
            if (!item.isBlock()) {
                item.setShortCommand(item.getShortCommand() + sbShort.substring(levelSpace.length() + item.getShortCommand().length()));
                item.setLongCommand(item.getLongCommand() + sbLong.substring(item.getLongCommand().length()));
                Object description = item.getDescription();
                if (item.getAvailableOptions() != null) {
                    description = (String)description + "\n*Options: " + item.getAvailableOptions();
                }
                if (item.isMultiple()) {
                    description = (String)description + "\n*Repeatable";
                }
                String[] split = ((String)description).split("[\r\n\f]+");
                for (int i = 0; i < split.length; ++i) {
                    String descline = split[i];
                    if (i == 0) {
                        toPrint.append((CharSequence)levelSpace).append(item.getShortCommand()).append("  ").append(item.getLongCommand()).append("  ").append(descline).append("\n");
                        continue;
                    }
                    toPrint.append((CharSequence)sbShort).append("  ").append((CharSequence)sbLong).append("  ").append(descline).append("\n");
                }
                continue;
            }
            if (!firstLine) {
                toPrint.append("\n");
            }
            toPrint.append((CharSequence)levelSpace).append(item.getDescription()).append("\n");
            toPrint.append("\n");
            firstLine = false;
        }
        return toPrint.toString();
    }
}

