/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.cli;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.kendar.cli.CommandItem;
import org.kendar.cli.CommandOptions;
import org.kendar.cli.HelpLine;
import org.kendar.cli.MainArg;
import org.kendar.exceptions.CliException;

public class CommandOption
implements CommandItem {
    private final String shortCommand;
    private final String description;
    private final List<CommandOptions> subChoices = new ArrayList<CommandOptions>();
    private final Map<String, CommandOptions> subChoicesValues = new HashMap<String, CommandOptions>();
    private final Map<String, CommandOption> subOptionsValues = new HashMap<String, CommandOption>();
    private final HashSet<String> duplicateGuardSubChoices = new HashSet();
    private final HashSet<String> duplicateGuardSubOptions = new HashSet();
    private final List<CommandOption> subOptions = new ArrayList<CommandOption>();
    private boolean hasParameter;
    private boolean mandatoryParameter;
    private String longCommand;
    private List<String> values;
    private boolean multipleSubChoices;
    private Consumer<String> callback;
    private boolean present;
    private String subChoicesDescription;
    private CommandItem parent;
    private boolean multiple;
    private Consumer<List<String>> multiCallback;

    private CommandOption(String shortCommand, String description) {
        this.shortCommand = shortCommand;
        this.description = description;
    }

    public static CommandOption of(String shortCommand, String description) {
        return new CommandOption(shortCommand, description);
    }

    public CommandOption asMultiple() {
        this.multiple = true;
        return this;
    }

    public boolean isPresent() {
        return this.present || this.values != null && !this.values.isEmpty();
    }

    public boolean isMultipleSubChoices() {
        return this.multipleSubChoices;
    }

    public Map<String, CommandOptions> getSubChoicesValues() {
        return this.subChoicesValues;
    }

    public boolean hasSubChoices() {
        return !this.subChoices.isEmpty();
    }

    public String toString() {
        ArrayList<CallSite> all = new ArrayList<CallSite>();
        if (this.shortCommand != null) {
            all.add((CallSite)((Object)("shortCommand='" + this.shortCommand + "'")));
        }
        if (this.longCommand != null) {
            all.add((CallSite)((Object)("longCommand='" + this.longCommand + "'")));
        }
        return "CommandOption{" + String.join((CharSequence)",", all) + "}";
    }

    public String getShortCommand() {
        return this.shortCommand;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isHasParameter() {
        return this.hasParameter;
    }

    public boolean isMandatoryParameter() {
        return this.mandatoryParameter;
    }

    public String getLongCommand() {
        return this.longCommand;
    }

    public List<CommandOptions> getSubChoices() {
        return this.subChoices;
    }

    public CommandOption withParameter() {
        this.hasParameter = true;
        return this;
    }

    public CommandOption withMandatoryParameter() {
        this.mandatoryParameter = true;
        return this.withParameter();
    }

    public CommandOption withLong(String longCommand) {
        this.longCommand = longCommand;
        return this;
    }

    public CommandOption withSubChoices(CommandOptions ... subChoices) {
        for (CommandOptions commandOption : subChoices) {
            commandOption.setParent(this);
            if (this.duplicateGuardSubChoices.contains(commandOption.getId().toLowerCase())) {
                throw new CliException("Duplicate sub choice " + commandOption.getId());
            }
            this.duplicateGuardSubChoices.add(commandOption.getId().toLowerCase());
        }
        this.subChoices.addAll(List.of(subChoices));
        return this;
    }

    public List<String> getLongShortCommandsChild() {
        ArrayList<String> result = new ArrayList<String>();
        for (CommandOptions commandOptions : this.subChoices) {
            result.addAll(commandOptions.getLongShortCommands());
        }
        for (CommandOption commandOption : this.subOptions) {
            result.addAll(commandOption.getLongShortCommands());
        }
        return result;
    }

    public List<String> getLongShortCommands() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.shortCommand != null) {
            result.add(this.shortCommand);
        }
        if (this.longCommand != null) {
            result.add(this.longCommand);
        }
        for (CommandOptions commandOption : this.subChoices) {
            result.addAll(commandOption.getLongShortCommands());
        }
        return result;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        if (this.values == null) {
            this.values = values;
        } else {
            this.values.addAll(values);
        }
        if (this.multiCallback != null) {
            this.multiCallback.accept(this.values);
        } else if (this.callback != null) {
            if (!this.isHasParameter()) {
                this.callback.accept(null);
            } else {
                this.callback.accept(values.get(0));
            }
        }
    }

    public CommandOption withMultipleSubChoices() {
        this.multipleSubChoices = true;
        return this;
    }

    public void setValues(String value, CommandOptions subChoice) {
        this.subChoicesValues.put(value.toLowerCase(), subChoice);
    }

    public void setPresent() {
        this.present = true;
    }

    public boolean hasOption(String id) {
        String[] mainAndChild = id.toLowerCase().split("\\.", 2);
        if (this.subChoicesValues.containsKey(mainAndChild[0])) {
            if (mainAndChild.length == 1) {
                return true;
            }
            return this.subChoicesValues.get(mainAndChild[0]).hasOption(mainAndChild[1]);
        }
        if (this.subOptionsValues.containsKey(mainAndChild[0])) {
            if (mainAndChild.length == 1) {
                return this.subOptionsValues.get(mainAndChild[0]).isPresent();
            }
            return this.subOptionsValues.get(mainAndChild[0]).hasOption(mainAndChild[1]);
        }
        return false;
    }

    public List<String> getOptionValues(String id) {
        String[] mainAndChild = id.toLowerCase().split("\\.", 2);
        if (this.subChoicesValues.containsKey(mainAndChild[0])) {
            if (mainAndChild.length == 1) {
                return new ArrayList<String>();
            }
            return this.subChoicesValues.get(mainAndChild[0]).getOptionValues(mainAndChild[1]);
        }
        if (this.subOptionsValues.containsKey(mainAndChild[0])) {
            if (mainAndChild.length == 1) {
                return this.subOptionsValues.get(mainAndChild[0]).getValues();
            }
            return this.subOptionsValues.get(mainAndChild[0]).getOptionValues(mainAndChild[1]);
        }
        return new ArrayList<String>();
    }

    public CommandOption withCallback(Consumer<String> callback) {
        this.callback = callback;
        return this;
    }

    public CommandOption withMultiCallback(Consumer<List<String>> callback) {
        this.multiCallback = callback;
        return this;
    }

    public String getSubChoicesDescription() {
        return this.subChoicesDescription;
    }

    public CommandOption withSubChoicesDescription(String subChoicesDescription) {
        this.subChoicesDescription = subChoicesDescription;
        return this;
    }

    public CommandOption getCommandOption(String id) {
        String[] mainAndChild = id.toLowerCase().split("\\.", 2);
        if (this.subChoicesValues.containsKey(mainAndChild[0])) {
            if (mainAndChild.length == 1) {
                return null;
            }
            return this.subChoicesValues.get(mainAndChild[0]).getCommandOption(mainAndChild[1]);
        }
        if (this.subOptionsValues.containsKey(mainAndChild[0])) {
            if (mainAndChild.length == 1) {
                return this.subOptionsValues.get(mainAndChild[0]);
            }
            return this.subOptionsValues.get(mainAndChild[0]).getCommandOption(mainAndChild[1]);
        }
        return null;
    }

    public CommandOption withCommandOptions(CommandOption ... subOptionsList) {
        for (CommandOption commandOption : subOptionsList) {
            commandOption.setParent(this);
            if (commandOption.getShortCommand() != null && this.duplicateGuardSubOptions.contains(commandOption.getShortCommand().toLowerCase())) {
                throw new CliException("Duplicate sub option " + commandOption);
            }
            if (commandOption.getLongCommand() != null && this.duplicateGuardSubOptions.contains(commandOption.getLongCommand().toLowerCase())) {
                throw new CliException("Duplicate sub option " + commandOption);
            }
            if (commandOption.getShortCommand() != null) {
                this.subOptionsValues.put(commandOption.getShortCommand().toLowerCase(), commandOption);
                this.duplicateGuardSubOptions.add(commandOption.getShortCommand().toLowerCase());
            }
            if (commandOption.getLongCommand() == null) continue;
            this.subOptionsValues.put(commandOption.getLongCommand().toLowerCase(), commandOption);
            this.duplicateGuardSubOptions.add(commandOption.getLongCommand().toLowerCase());
        }
        this.subOptions.addAll(List.of(subOptionsList));
        return this;
    }

    public boolean hasSubOptions() {
        return !this.subOptions.isEmpty();
    }

    public void parseInternal(List<MainArg> mainArgs) {
        CommandOptions.parseListOfCommands(mainArgs, this.subOptions, this, false);
    }

    @Override
    public List<CommandOption> getCommandOptions() {
        return this.subOptions;
    }

    public void printHelp(ArrayList<HelpLine> result, int level) {
        if (this.subOptions.isEmpty() && this.subChoices.isEmpty()) {
            result.add(new HelpLine(this.getShortCommand(), this.getLongCommand(), this.getDescription(), null, this.isMultiple(), level));
        }
        CommandOptions.printHelpListOfCommands(result, this.subOptions, level);
    }

    @Override
    public CommandItem getParent() {
        return this.parent;
    }

    @Override
    public void setParent(CommandItem parent) {
        this.parent = parent;
    }

    public boolean isMultiple() {
        return this.multiple;
    }
}

