/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.cli;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.kendar.cli.CommandItem;
import org.kendar.cli.CommandOption;
import org.kendar.cli.HelpLine;
import org.kendar.cli.MainArg;
import org.kendar.exceptions.CliException;

public class CommandOptions
implements CommandItem {
    private final String id;
    private final List<CommandOption> commandOptions = new ArrayList<CommandOption>();
    private final Set<String> duplicateGuard = new HashSet<String>();
    private Consumer<String> callback;
    private String description;
    private CommandItem parent;

    private CommandOptions(String id, String description) {
        this.id = id;
        this.description = description;
    }

    public static CommandOptions of(String id) {
        return new CommandOptions(id, null);
    }

    public static CommandOptions of(String id, String description) {
        return new CommandOptions(id, description);
    }

    protected static void parseListOfCommands(List<MainArg> mainArgs, List<CommandOption> co, CommandItem caller, boolean multiple) {
        for (CommandOption item : co) {
            Optional<MainArg> arg;
            boolean isMine;
            CommandItem parent;
            int matchingArgIndex;
            boolean foundedMatchingArg = false;
            for (matchingArgIndex = 0; matchingArgIndex < mainArgs.size(); ++matchingArgIndex) {
                MainArg mainArg = mainArgs.get(matchingArgIndex);
                if (!mainArg.getId().equalsIgnoreCase(item.getLongCommand()) && !mainArg.getId().equalsIgnoreCase(item.getShortCommand())) continue;
                foundedMatchingArg = true;
                break;
            }
            if (!foundedMatchingArg || (parent = caller.getParent()) != null && !(isMine = CommandOptions.checkIfItIsMine(mainArgs, parent, matchingArgIndex)) || (arg = mainArgs.stream().filter(a -> a.getId().equalsIgnoreCase(item.getShortCommand()) || a.getId().equalsIgnoreCase(item.getLongCommand())).findFirst()).isEmpty()) continue;
            if (!item.hasSubChoices()) {
                mainArgs.remove(arg.get());
                if (item.isMandatoryParameter() && arg.get().getValues().isEmpty()) {
                    throw new CliException("Mandatory parameter " + item + " not present");
                }
                item.setValues(arg.get().getValues());
                item.setPresent();
                if (item.isMultiple()) {
                    CommandOptions.parseListOfCommands(mainArgs, co, caller, true);
                }
                if (multiple) break;
                if (!item.hasSubOptions()) continue;
                item.parseInternal(mainArgs);
                continue;
            }
            do {
                HashSet choices = item.getSubChoices().stream().map(CommandOptions::getId).collect(Collectors.toCollection(HashSet::new));
                String availableChoices = String.join((CharSequence)", ", choices);
                if (arg.get().getValues().isEmpty()) {
                    throw new CliException("Missing value " + item + " in command option " + item + " available choices are " + availableChoices);
                }
                if (arg.get().getValues().size() > 1) {
                    throw new CliException("Duplicate value " + item + " in command option " + item + " available choices are " + availableChoices);
                }
                String value = arg.get().getValues().get(0);
                if (!choices.contains(value)) {
                    throw new CliException("Wrong value " + value + " in command option " + item + " available choices are " + availableChoices);
                }
                mainArgs.remove(arg.get());
                Optional<CommandOptions> itemPossible = item.getSubChoices().stream().filter(sc -> sc.getId().equalsIgnoreCase(value)).findFirst();
                if (itemPossible.isEmpty()) {
                    throw new CliException("Wrong option " + value + " in command option " + item + " available choices are " + availableChoices);
                }
                CommandOptions subChoice = itemPossible.get();
                if (subChoice.callback != null) {
                    subChoice.callback.accept(value);
                }
                subChoice.parseInternal(mainArgs);
                item.setValues(value, subChoice);
            } while (item.isMultipleSubChoices() && !(arg = mainArgs.stream().filter(a -> a.getId().equalsIgnoreCase(item.getShortCommand()) || a.getId().equalsIgnoreCase(item.getLongCommand())).findFirst()).isEmpty());
        }
    }

    private static boolean checkIfItIsMine(List<MainArg> mainArgs, CommandItem parent, int matchingArgIndex) {
        boolean isMine = true;
        List<CommandOption> commandOptions = parent.getCommandOptions();
        block0: for (CommandOption coFounded : commandOptions) {
            for (int arg = 0; arg < matchingArgIndex; ++arg) {
                MainArg wrongArg = mainArgs.get(arg);
                if (!wrongArg.getId().equalsIgnoreCase(coFounded.getLongCommand()) && !wrongArg.getId().equalsIgnoreCase(coFounded.getShortCommand())) continue;
                isMine = false;
                continue block0;
            }
        }
        return isMine;
    }

    protected static void printHelpListOfCommands(ArrayList<HelpLine> result, List<CommandOption> co, int level) {
        for (CommandOption item : co) {
            if (item.hasSubChoices()) {
                HashSet choices = item.getSubChoices().stream().map(CommandOptions::getId).collect(Collectors.toCollection(HashSet::new));
                String availableChoices = String.join((CharSequence)"|", choices);
                result.add(new HelpLine(item.getShortCommand(), item.getLongCommand(), item.getDescription(), availableChoices, item.isMultiple(), level + 1));
                if (item.getSubChoicesDescription() != null) {
                    result.add(new HelpLine(item.getSubChoicesDescription(), level));
                }
                for (CommandOptions choice : item.getSubChoices()) {
                    if (choice.getDescription() == null) continue;
                    result.add(new HelpLine(choice.getDescription() + " (" + choice.getId() + ")", level));
                    choice.printHelp(result, level);
                }
            } else {
                result.add(new HelpLine(item.getShortCommand(), item.getLongCommand(), item.getDescription(), null, item.isMultiple(), level + 1));
            }
            if (!item.hasSubOptions()) continue;
            for (CommandOption choice : item.getCommandOptions()) {
                if (choice.getDescription() == null) continue;
                choice.printHelp(result, level + 2);
            }
        }
    }

    @Override
    public List<CommandOption> getCommandOptions() {
        return this.commandOptions;
    }

    public String getId() {
        return this.id;
    }

    public CommandOptions withOptions(CommandOption ... commandOptions) {
        for (CommandOption commandOption : commandOptions) {
            commandOption.setParent(this);
            if (commandOption.hasSubChoices()) {
                if (commandOption.getLongCommand() != null) {
                    if (this.duplicateGuard.contains(commandOption.getLongCommand())) {
                        throw new CliException("Duplicate command " + commandOption + " " + commandOption.getLongCommand());
                    }
                    this.duplicateGuard.add(commandOption.getLongCommand());
                }
                if (commandOption.getShortCommand() == null) continue;
                if (this.duplicateGuard.contains(commandOption.getShortCommand())) {
                    throw new CliException("Duplicate command " + commandOption + " " + commandOption.getShortCommand());
                }
                this.duplicateGuard.add(commandOption.getShortCommand());
                continue;
            }
            for (String item : commandOption.getLongShortCommands()) {
                if (this.duplicateGuard.contains(item.toLowerCase())) {
                    throw new CliException("Duplicate inherited command " + item + " on option " + commandOption);
                }
                this.duplicateGuard.add(item.toLowerCase());
            }
        }
        for (CommandOption commandOption : commandOptions) {
            if (!commandOption.hasSubChoices() && !commandOption.hasSubOptions()) continue;
            for (String item : commandOption.getLongShortCommandsChild()) {
                if (!this.duplicateGuard.contains(item.toLowerCase())) continue;
                throw new CliException("Duplicate inherited command " + item + " on option " + commandOption);
            }
        }
        this.commandOptions.addAll(List.of(commandOptions));
        return this;
    }

    public List<String> getLongShortCommands() {
        ArrayList<String> result = new ArrayList<String>();
        for (CommandOption item : this.commandOptions) {
            result.addAll(item.getLongShortCommands());
        }
        return result;
    }

    public List<String> getLongShortCommandsChild() {
        ArrayList<String> result = new ArrayList<String>();
        for (CommandOption item : this.commandOptions) {
            result.addAll(item.getLongShortCommandsChild());
        }
        return result;
    }

    public void parse(List<MainArg> mainArgs, boolean ignoreMissing) {
        this.parseInternal(mainArgs);
        if (!ignoreMissing && !mainArgs.isEmpty()) {
            throw new CliException("Unknown options " + mainArgs);
        }
    }

    public void parseInternal(List<MainArg> mainArgs) {
        CommandOptions.parseListOfCommands(mainArgs, this.commandOptions, this, false);
    }

    public boolean hasOption(String id) {
        String[] mainAndChild = id.toLowerCase().split("\\.", 2);
        for (CommandOption item : this.commandOptions) {
            if ((item.getShortCommand() == null || !item.getShortCommand().equalsIgnoreCase(mainAndChild[0])) && (item.getLongCommand() == null || !item.getLongCommand().equalsIgnoreCase(mainAndChild[0]))) continue;
            if (item.hasSubChoices()) {
                if (mainAndChild.length == 1) {
                    return !item.getSubChoicesValues().isEmpty();
                }
                if (!item.hasOption(mainAndChild[1])) continue;
                return true;
            }
            if (!item.isPresent()) continue;
            return true;
        }
        return false;
    }

    public List<String> getOptionValues(String id) {
        String[] mainAndChild = id.toLowerCase().split("\\.", 2);
        for (CommandOption item : this.commandOptions) {
            if ((item.getShortCommand() == null || !item.getShortCommand().equalsIgnoreCase(mainAndChild[0])) && (item.getLongCommand() == null || !item.getLongCommand().equalsIgnoreCase(mainAndChild[0]))) continue;
            if (item.hasSubOptions() && mainAndChild.length > 1 && item.hasOption(mainAndChild[1])) {
                return item.getOptionValues(mainAndChild[1]);
            }
            if (item.hasSubChoices()) {
                if (mainAndChild.length == 1) {
                    return new ArrayList<String>(item.getSubChoicesValues().keySet());
                }
                if (!item.hasOption(mainAndChild[1])) continue;
                return item.getOptionValues(mainAndChild[1]);
            }
            if (!item.isPresent()) continue;
            return item.getValues();
        }
        return null;
    }

    public CommandOptions withCallback(Consumer<String> callback) {
        this.callback = callback;
        return this;
    }

    public void printHelp(ArrayList<HelpLine> result, int level) {
        CommandOptions.printHelpListOfCommands(result, this.commandOptions, level);
    }

    public String getDescription() {
        return this.description;
    }

    public CommandOptions withDescription(String description) {
        this.description = description;
        return this;
    }

    public CommandOption getCommandOption(String id) {
        String[] mainAndChild = id.toLowerCase().split("\\.", 2);
        for (CommandOption item : this.commandOptions) {
            if (!mainAndChild[0].equalsIgnoreCase(item.getShortCommand()) && !mainAndChild[0].equalsIgnoreCase(item.getLongCommand())) continue;
            if (!item.hasSubChoices() || mainAndChild.length == 1) {
                return item;
            }
            CommandOption result = item.getCommandOption(mainAndChild[1]);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public CommandItem getParent() {
        return this.parent;
    }

    @Override
    public void setParent(CommandItem parent) {
        this.parent = parent;
    }
}

