/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import org.kendar.sync.client.CommandLineArgs;
import org.kendar.sync.lib.model.FileInfo;
import org.kendar.sync.lib.network.TcpConnection;
import org.kendar.sync.lib.protocol.FileDataAck;
import org.kendar.sync.lib.protocol.FileDataMessage;
import org.kendar.sync.lib.protocol.FileDescriptorAckMessage;
import org.kendar.sync.lib.protocol.FileDescriptorMessage;
import org.kendar.sync.lib.protocol.FileEndAckMessage;
import org.kendar.sync.lib.protocol.FileEndMessage;
import org.kendar.sync.lib.protocol.Message;
import org.kendar.sync.lib.protocol.MessageType;
import org.kendar.sync.lib.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseSyncClientProcess {
    private static final Logger log = LoggerFactory.getLogger(BaseSyncClientProcess.class);

    protected void scanDirectory(File directory, String basePath, List<FileInfo> files, boolean ignoreHiddenFiles, boolean ignoreSystemFiles) throws IOException {
        files.add(FileInfo.fromFile(directory, basePath));
        File[] children = directory.listFiles();
        if (children != null) {
            for (File child : children) {
                BasicFileAttributes attr;
                if (child.isHidden() && ignoreHiddenFiles || (attr = Files.readAttributes(child.toPath(), BasicFileAttributes.class, new LinkOption[0])).isSymbolicLink() || child.getName().startsWith(".") && ignoreSystemFiles) continue;
                if (child.isDirectory()) {
                    this.scanDirectory(child, basePath, files, ignoreHiddenFiles, ignoreSystemFiles);
                    continue;
                }
                files.add(FileInfo.fromFile(child, basePath));
            }
        }
    }

    protected void transferFile(FileInfo file, CommandLineArgs args, TcpConnection connection) throws IOException {
        String threadName = Thread.currentThread().getName();
        int connectionId = connection.getConnectionId();
        log.debug("[CLIENT-{}] Starting transfer of {}", (Object)connectionId, (Object)file.getRelativePath());
        FileDescriptorMessage fileDescriptorMessage = new FileDescriptorMessage(file);
        connection.sendMessage(fileDescriptorMessage);
        Message response = connection.receiveMessage();
        if (response.getMessageType() != MessageType.FILE_DESCRIPTOR_ACK) {
            log.error("[CLIENT-{}] Unexpected response: {}", (Object)connectionId, (Object)response.getMessageType());
            return;
        }
        FileDescriptorAckMessage fileDescriptorAck = (FileDescriptorAckMessage)response;
        if (!fileDescriptorAck.isReady()) {
            log.error("[CLIENT-{}] Server not ready to receive file: {}", (Object)connectionId, (Object)fileDescriptorAck.getErrorMessage());
            return;
        }
        if (file.isDirectory()) {
            log.debug("[CLIENT-{}] Created directory: {}", (Object)connectionId, (Object)file.getRelativePath());
            return;
        }
        if (!args.isDryRun()) {
            int maxPacketSize;
            File sourceFile = new File(Path.of(args.getSourceFolder(), file.getRelativePath()).toString());
            long fileSize = sourceFile.length();
            int totalBlocks = (int)Math.ceil((double)fileSize / (double)(maxPacketSize = connection.getMaxPacketSize()));
            if (totalBlocks == 0) {
                totalBlocks = 1;
            }
            log.debug("[CLIENT-{}] Sending file {} in {} blocks ({} bytes)", connectionId, file.getRelativePath(), totalBlocks, fileSize);
            try (FileInputStream fis = new FileInputStream(sourceFile);){
                int bytesRead;
                byte[] buffer = new byte[maxPacketSize];
                int blockNumber = 0;
                while ((bytesRead = fis.read(buffer)) != -1) {
                    byte[] blockData = bytesRead == buffer.length ? buffer : Arrays.copyOf(buffer, bytesRead);
                    FileDataMessage fileDataMessage = new FileDataMessage(file.getRelativePath(), blockNumber, totalBlocks, blockData);
                    connection.sendMessage(fileDataMessage);
                    Message fileAck = connection.receiveMessage();
                    if (fileAck.getMessageType() != MessageType.FILE_DATA_ACK) {
                        log.error("[CLIENT-{}] Unexpected response 9: {}", (Object)connectionId, (Object)response.getMessageType());
                        return;
                    }
                    log.debug("[CLIENT-{}] Sent block {} of {} ({} bytes)", connectionId, blockNumber + 1, totalBlocks, blockData.length);
                    ++blockNumber;
                }
            }
        } else {
            log.debug("[CLIENT-{}] Dry run: Would send file data for {}", (Object)connectionId, (Object)file.getRelativePath());
        }
        log.debug("[CLIENT-{}] Send end: {}", (Object)connectionId, (Object)file.getRelativePath());
        FileEndMessage fileEndMessage = new FileEndMessage(file.getRelativePath(), file);
        connection.sendMessage(fileEndMessage);
        response = connection.receiveMessage();
        if (response.getMessageType() != MessageType.FILE_END_ACK) {
            log.error("[CLIENT-{}] Unexpected response: {}", (Object)connectionId, (Object)response.getMessageType());
            return;
        }
        FileEndAckMessage fileEndAck = (FileEndAckMessage)response;
        if (!fileEndAck.isSuccess()) {
            log.error("[CLIENT-{}] File transfer failed: {}", (Object)connectionId, (Object)fileEndAck.getErrorMessage());
            return;
        }
        log.debug("[CLIENT-{}] Transferred file: {}", (Object)connectionId, (Object)file.getRelativePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performSingleFileRestore(CommandLineArgs args, ConcurrentLinkedQueue<TcpConnection> connections, ConcurrentHashMap<String, FileInfo> mapToTransfer, Semaphore semaphore, CountDownLatch completionLatch) {
        TcpConnection currentConnection = null;
        FileInfo fileInfo = null;
        try {
            currentConnection = connections.poll();
            if (currentConnection == null) {
                log.error("[CLIENT] No available connections for file transfer");
                return;
            }
            Message message = currentConnection.receiveMessage();
            if (message == null) {
                return;
            }
            if (message.getMessageType() != MessageType.FILE_DESCRIPTOR) {
                log.error("[CLIENT] Unexpected message 1: {}", (Object)message.getMessageType());
                return;
            }
            FileDescriptorMessage fileDescriptorMessage = (FileDescriptorMessage)message;
            fileInfo = fileDescriptorMessage.getFileInfo();
            if (!mapToTransfer.containsKey(FileUtils.makeUniformPath(fileInfo.getRelativePath()))) {
                log.debug("[CLIENT] Skipping file not in transfer list: {}", (Object)fileInfo.getRelativePath());
                FileDescriptorAckMessage fileDescriptorAck = FileDescriptorAckMessage.ready(fileInfo.getRelativePath());
                currentConnection.sendMessage(fileDescriptorAck);
                return;
            }
            log.debug("[CLIENT] Receiving file: {}", (Object)fileInfo.getRelativePath());
            File targetFile = new File(args.getSourceFolder(), fileInfo.getRelativePath());
            if (fileInfo.isDirectory()) {
                if (!args.isDryRun()) {
                    targetFile.mkdirs();
                } else {
                    log.debug("[CLIENT] Dry run: Would create directory {}", (Object)targetFile.getAbsolutePath());
                }
                FileDescriptorAckMessage fileDescriptorAck = FileDescriptorAckMessage.ready(fileInfo.getRelativePath());
                currentConnection.sendMessage(fileDescriptorAck);
                return;
            }
            if (!args.isDryRun()) {
                targetFile.getParentFile().mkdirs();
            } else {
                log.debug("[CLIENT] Dry run: Would create parent directories for {}", (Object)targetFile.getAbsolutePath());
            }
            FileDescriptorAckMessage fileDescriptorAck = FileDescriptorAckMessage.ready(fileInfo.getRelativePath());
            currentConnection.sendMessage(fileDescriptorAck);
            message = currentConnection.receiveMessage();
            if (message.getMessageType() != MessageType.FILE_DATA) {
                log.error("[CLIENT] Unexpected message 2: {}", (Object)message.getMessageType());
                return;
            }
            FileDataMessage fileDataMessage = (FileDataMessage)message;
            while (true) {
                if (!args.isDryRun()) {
                    targetFile.getParentFile().mkdirs();
                    try (FileOutputStream fos = new FileOutputStream(targetFile, fileDataMessage.isFirstBlock());){
                        fos.write(fileDataMessage.getData());
                    }
                } else {
                    log.debug("[CLIENT] Dry run: Would write file data to {}", (Object)targetFile.getAbsolutePath());
                }
                currentConnection.sendMessage(new FileDataAck());
                message = currentConnection.receiveMessage();
                if (message.getMessageType() != MessageType.FILE_DATA) {
                    if (fileDataMessage.isLastBlock()) break;
                    log.error("[CLIENT] Unexpected message 3: {}", (Object)message.getMessageType());
                    return;
                }
                fileDataMessage = (FileDataMessage)message;
            }
            if (message.getMessageType() != MessageType.FILE_END) {
                log.error("[CLIENT] Unexpected message 4: {}", (Object)message.getMessageType());
                return;
            }
            FileEndAckMessage fileEndAck = FileEndAckMessage.success(fileInfo.getRelativePath());
            currentConnection.sendMessage(fileEndAck);
            Path realPath = targetFile.toPath();
            Files.setAttribute(realPath, "creationTime", FileTime.fromMillis(fileInfo.getCreationTime().toEpochMilli()), new LinkOption[0]);
            Files.setLastModifiedTime(realPath, FileTime.fromMillis(fileInfo.getModificationTime().toEpochMilli()));
            log.debug("[CLIENT] Received file: {}", (Object)fileInfo.getRelativePath());
        }
        catch (Exception e) {
            log.error("[CLIENT] Error receiving file: {}", (Object)e.getMessage());
        }
        finally {
            try {
                if (currentConnection != null) {
                    connections.add(currentConnection);
                }
                if (fileInfo != null) {
                    mapToTransfer.remove(FileUtils.makeUniformPath(fileInfo.getRelativePath()));
                }
                completionLatch.countDown();
                semaphore.release();
            }
            catch (Exception e) {
                log.error("[CLIENT] Error releasing resources: {}", (Object)e.getMessage());
            }
        }
    }

    protected TcpConnection getTcpConnection(TcpConnection connection, CommandLineArgs args, int i, int maxPacketSize) throws IOException {
        Socket socket = new Socket(args.getServerAddress(), args.getServerPort());
        return new TcpConnection(socket, connection.getSessionId(), i + 1, maxPacketSize);
    }
}

