/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.lib.buffer.converters;

import java.nio.charset.StandardCharsets;
import org.kendar.sync.lib.buffer.ByteContainer;
import org.kendar.sync.lib.buffer.converters.ByteContainerConverter;
import org.kendar.sync.lib.buffer.converters.IntConverter;

public class StringConverter
extends ByteContainerConverter<String> {
    private static final IntConverter intConverter = new IntConverter();

    @Override
    public Class<String> getType() {
        return String.class;
    }

    @Override
    public String fromBytes(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Override
    public int getSize(ByteContainer container, int offset) {
        char type;
        int intSize = intConverter.getSize();
        int size = 0;
        if (offset == -1) {
            type = (char)container.read();
            size = intConverter.fromBytes(container.read(intSize));
        } else {
            type = (char)container.read(offset, 1)[0];
            size = intConverter.fromBytes(container.read(intSize, offset));
        }
        if (type != 'S') {
            throw new RuntimeException("type is not 'S/String'");
        }
        return size;
    }

    @Override
    public byte[] toBytes(String input) {
        byte[] data = input.getBytes(StandardCharsets.UTF_8);
        byte[] result = new byte[data.length + 5];
        byte[] length = intConverter.toBytes(data.length);
        result[0] = 83;
        System.arraycopy(length, 0, result, 1, length.length);
        System.arraycopy(data, 0, result, 5, data.length);
        return result;
    }

    @Override
    public int getSize() {
        return 0;
    }
}

