/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.lib.network;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.UUID;
import org.kendar.sync.lib.protocol.Message;
import org.kendar.sync.lib.protocol.Packet;

public class TcpConnection
implements AutoCloseable {
    private final Socket socket;
    private final int packetId;
    private final int maxPacketSize;
    private final OutputStream outputStream;
    private InputStream inputStream;
    private UUID sessionId;
    private int connectionId;
    private Runnable sessionTouch;

    public TcpConnection(Socket socket, UUID sessionId, int connectionId, int maxPacketSize) throws IOException {
        this.socket = socket;
        this.inputStream = socket.getInputStream();
        this.outputStream = socket.getOutputStream();
        this.sessionId = sessionId;
        this.connectionId = connectionId;
        this.packetId = 0;
        this.maxPacketSize = maxPacketSize;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TcpConnection)) {
            return false;
        }
        TcpConnection that = (TcpConnection)o;
        return Objects.equals(this.socket, that.socket);
    }

    public int hashCode() {
        return Objects.hashCode(this.socket);
    }

    public void sendMessage(Message message) throws IOException {
        byte[] messageData = message.serialize();
        Packet packet = new Packet(this.connectionId, this.sessionId, this.packetId, message.getMessageType().getCode(), messageData);
        byte[] packetData = packet.serialize();
        this.outputStream.write(packetData);
        this.outputStream.flush();
        if (this.sessionTouch != null) {
            this.sessionTouch.run();
        }
    }

    public Message receiveMessage() throws IOException {
        if (this.sessionTouch != null) {
            this.sessionTouch.run();
        }
        byte[] lengthBytes = new byte[4];
        this.inputStream = this.socket.getInputStream();
        int bytesRead = this.inputStream.read(lengthBytes);
        if (bytesRead != 4) {
            if (bytesRead == -1) {
                return null;
            }
            throw new IOException("Failed to read packet length");
        }
        int packetLength = ByteBuffer.wrap(lengthBytes).getInt();
        if (packetLength <= 0 || packetLength > this.maxPacketSize + 1024) {
            throw new IOException("Invalid packet length: " + packetLength);
        }
        byte[] packetData = new byte[packetLength];
        System.arraycopy(lengthBytes, 0, packetData, 0, 4);
        int offset = 4;
        for (int remaining = packetLength - 4; remaining > 0; remaining -= bytesRead) {
            bytesRead = this.inputStream.read(packetData, offset, remaining);
            if (bytesRead == -1) {
                throw new IOException("End of stream reached");
            }
            offset += bytesRead;
        }
        Packet packet = Packet.deserialize(packetData);
        Message result = Message.deserialize(packet.getDecompressedContent());
        result.initialize(packet.getConnectionId(), packet.getSessionId(), packet.getPacketId());
        return result;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
        this.outputStream.close();
        this.socket.close();
    }

    public UUID getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(UUID sessionId) {
        this.sessionId = sessionId;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(int connectionId) {
        this.connectionId = connectionId;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public boolean isClosed() {
        return !this.socket.isConnected() || this.socket.isClosed() || !this.socket.isBound();
    }

    public void setSession(Runnable sessionTouch) {
        this.sessionTouch = sessionTouch;
    }
}

