/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.lib.protocol;

import org.kendar.sync.lib.buffer.ByteContainer;
import org.kendar.sync.lib.protocol.Message;
import org.kendar.sync.lib.protocol.MessageType;

public class ConnectMessage
extends Message {
    private String username;
    private String password;
    private String targetFolder;
    private int maxPacketSize;
    private int maxConnections;
    private boolean dryRun;
    private String hostName;

    public ConnectMessage() {
    }

    public ConnectMessage(String username, String password, String targetFolder, int maxPacketSize, int maxConnections, boolean dryRun, String hostName) {
        this.username = username;
        this.password = password;
        this.targetFolder = targetFolder;
        this.maxPacketSize = maxPacketSize;
        this.maxConnections = maxConnections;
        this.dryRun = dryRun;
        this.hostName = hostName;
    }

    @Override
    protected Message deserialize(ByteContainer buffer) {
        this.username = buffer.readType(String.class);
        this.password = buffer.readType(String.class);
        this.targetFolder = buffer.readType(String.class);
        this.maxPacketSize = buffer.readType(Integer.class);
        this.maxConnections = buffer.readType(Integer.class);
        this.dryRun = buffer.readType(Boolean.class);
        this.hostName = buffer.readType(String.class);
        return this;
    }

    @Override
    public MessageType getMessageType() {
        return MessageType.CONNECT;
    }

    @Override
    protected void serialize(ByteContainer buffer) {
        buffer.writeType(this.username);
        buffer.writeType(this.password);
        buffer.writeType(this.targetFolder);
        buffer.writeType(this.maxPacketSize);
        buffer.writeType(this.maxConnections);
        buffer.writeType(this.dryRun);
        buffer.writeType(this.hostName);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTargetFolder() {
        return this.targetFolder;
    }

    public void setTargetFolder(String targetFolder) {
        this.targetFolder = targetFolder;
    }

    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public void setMaxPacketSize(int maxPacketSize) {
        this.maxPacketSize = maxPacketSize;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    static {
        Message.registerMessageType(ConnectMessage.class);
    }
}

