/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.lib.protocol;

import org.kendar.sync.lib.buffer.ByteContainer;
import org.kendar.sync.lib.protocol.BackupType;
import org.kendar.sync.lib.protocol.Message;
import org.kendar.sync.lib.protocol.MessageType;

public class ConnectResponseMessage
extends Message {
    private boolean accepted;
    private String errorMessage = "";
    private int maxPacketSize;
    private int maxConnections;
    private BackupType backupType;

    public ConnectResponseMessage() {
    }

    public ConnectResponseMessage(boolean accepted, String errorMessage, int maxPacketSize, int maxConnections, BackupType backupType) {
        this.accepted = accepted;
        this.errorMessage = errorMessage;
        this.maxPacketSize = maxPacketSize;
        this.maxConnections = maxConnections;
        this.backupType = backupType;
    }

    public static ConnectResponseMessage accepted(int maxPacketSize, int maxConnections) {
        return new ConnectResponseMessage(true, null, maxPacketSize, maxConnections, BackupType.NONE);
    }

    public static ConnectResponseMessage rejected(String errorMessage) {
        return new ConnectResponseMessage(false, errorMessage, 0, 0, BackupType.NONE);
    }

    @Override
    protected Message deserialize(ByteContainer buffer) {
        this.accepted = buffer.readType(Boolean.class);
        this.errorMessage = buffer.readType(String.class);
        this.maxPacketSize = buffer.readType(Integer.class);
        this.maxConnections = buffer.readType(Integer.class);
        this.backupType = buffer.readType(BackupType.class);
        return this;
    }

    @Override
    public MessageType getMessageType() {
        return MessageType.CONNECT_RESPONSE;
    }

    @Override
    protected void serialize(ByteContainer buffer) {
        buffer.writeType(this.accepted);
        if (this.errorMessage == null) {
            buffer.writeType("");
        } else {
            buffer.writeType(this.errorMessage);
        }
        buffer.writeType(this.maxPacketSize);
        buffer.writeType(this.maxConnections);
        buffer.writeType(this.backupType);
    }

    public BackupType getBackupType() {
        return this.backupType;
    }

    public void setBackupType(BackupType backupType) {
        this.backupType = backupType;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public void setAccepted(boolean accepted) {
        this.accepted = accepted;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public void setMaxPacketSize(int maxPacketSize) {
        this.maxPacketSize = maxPacketSize;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    static {
        Message.registerMessageType(ConnectResponseMessage.class);
    }
}

