/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.lib.protocol;

import org.kendar.sync.lib.buffer.ByteContainer;
import org.kendar.sync.lib.protocol.Message;
import org.kendar.sync.lib.protocol.MessageType;

public class FileDataMessage
extends Message {
    private String relativePath;
    private int blockNumber;
    private int totalBlocks;
    private byte[] data;

    public FileDataMessage() {
    }

    public FileDataMessage(String relativePath, int blockNumber, int totalBlocks, byte[] data) {
        this.relativePath = relativePath;
        this.blockNumber = blockNumber;
        this.totalBlocks = totalBlocks;
        this.data = data;
    }

    @Override
    public MessageType getMessageType() {
        return MessageType.FILE_DATA;
    }

    @Override
    protected Message deserialize(ByteContainer buffer) {
        this.relativePath = buffer.readType(String.class);
        this.blockNumber = buffer.readType(Integer.class);
        this.totalBlocks = buffer.readType(Integer.class);
        this.data = buffer.readType(byte[].class);
        return this;
    }

    @Override
    protected void serialize(ByteContainer buffer) {
        buffer.writeType(this.relativePath);
        buffer.writeType(this.blockNumber);
        buffer.writeType(this.totalBlocks);
        buffer.writeType(this.data);
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    public int getBlockNumber() {
        return this.blockNumber;
    }

    public void setBlockNumber(int blockNumber) {
        this.blockNumber = blockNumber;
    }

    public int getTotalBlocks() {
        return this.totalBlocks;
    }

    public void setTotalBlocks(int totalBlocks) {
        this.totalBlocks = totalBlocks;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public boolean isFirstBlock() {
        return this.blockNumber != 0;
    }

    public boolean isLastBlock() {
        return this.blockNumber == this.totalBlocks - 1;
    }

    static {
        Message.registerMessageType(FileDataMessage.class);
    }
}

