/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.lib.protocol;

import org.kendar.sync.lib.buffer.ByteContainer;
import org.kendar.sync.lib.protocol.Message;
import org.kendar.sync.lib.protocol.MessageType;

public class FileDescriptorAckMessage
extends Message {
    private String relativePath;
    private boolean ready;
    private String errorMessage;

    public FileDescriptorAckMessage() {
    }

    public FileDescriptorAckMessage(String relativePath, boolean ready, String errorMessage) {
        this.relativePath = relativePath;
        this.ready = ready;
        this.errorMessage = errorMessage;
    }

    public static FileDescriptorAckMessage ready(String relativePath) {
        return new FileDescriptorAckMessage(relativePath, true, null);
    }

    public static FileDescriptorAckMessage notReady(String relativePath, String errorMessage) {
        return new FileDescriptorAckMessage(relativePath, false, errorMessage);
    }

    @Override
    public MessageType getMessageType() {
        return MessageType.FILE_DESCRIPTOR_ACK;
    }

    @Override
    protected Message deserialize(ByteContainer buffer) {
        this.relativePath = buffer.readType(String.class);
        this.ready = buffer.readType(Boolean.class);
        this.errorMessage = buffer.readType(String.class);
        return this;
    }

    @Override
    protected void serialize(ByteContainer buffer) {
        buffer.writeType(this.relativePath);
        buffer.writeType(this.ready);
        if (this.errorMessage != null) {
            buffer.writeType(this.errorMessage);
        } else {
            buffer.writeType("");
        }
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    static {
        Message.registerMessageType(FileDescriptorAckMessage.class);
    }
}

