/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.lib.protocol;

import org.kendar.sync.lib.buffer.ByteContainer;
import org.kendar.sync.lib.protocol.Message;
import org.kendar.sync.lib.protocol.MessageType;

public class SyncEndMessage
extends Message {
    private boolean isBackup;
    private int filesTransferred;
    private int filesDeleted;

    public SyncEndMessage() {
    }

    public SyncEndMessage(boolean isBackup, int filesTransferred, int filesDeleted) {
        this.isBackup = isBackup;
        this.filesTransferred = filesTransferred;
        this.filesDeleted = filesDeleted;
    }

    @Override
    public MessageType getMessageType() {
        return MessageType.SYNC_END;
    }

    @Override
    protected Message deserialize(ByteContainer buffer) {
        this.isBackup = buffer.readType(Boolean.class);
        this.filesTransferred = buffer.readType(Integer.class);
        this.filesDeleted = buffer.readType(Integer.class);
        return this;
    }

    @Override
    protected void serialize(ByteContainer buffer) {
        buffer.writeType(this.isBackup);
        buffer.writeType(this.filesTransferred);
        buffer.writeType(this.filesDeleted);
    }

    public boolean isBackup() {
        return this.isBackup;
    }

    public void setBackup(boolean backup) {
        this.isBackup = backup;
    }

    public int getFilesTransferred() {
        return this.filesTransferred;
    }

    public void setFilesTransferred(int filesTransferred) {
        this.filesTransferred = filesTransferred;
    }

    public int getFilesDeleted() {
        return this.filesDeleted;
    }

    public void setFilesDeleted(int filesDeleted) {
        this.filesDeleted = filesDeleted;
    }

    static {
        Message.registerMessageType(SyncEndMessage.class);
    }
}

