/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.lib.utils;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kendar.sync.lib.model.FileInfo;
import org.kendar.sync.lib.protocol.BackupType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(String filename) throws IOException {
        String content = null;
        File file = new File(filename);
        try (FileReader reader = null;){
            reader = new FileReader(file);
            char[] chars = new char[(int)file.length()];
            reader.read(chars);
            content = new String(chars);
            reader.close();
        }
        return content;
    }

    public static String readFile(Path lastCompactLogPath) throws IOException {
        return FileUtils.readFile(lastCompactLogPath.toAbsolutePath().normalize().toString());
    }

    public static List<FileInfo> listFiles(File directory, String baseDir) throws IOException {
        ArrayList<FileInfo> files = new ArrayList<FileInfo>();
        FileUtils.listFilesRecursive(directory, baseDir, files);
        return files;
    }

    private static void listFilesRecursive(File directory, String baseDir, List<FileInfo> files) throws IOException {
        if (!directory.exists() || !directory.isDirectory()) {
            return;
        }
        File[] fileList = directory.listFiles();
        if (fileList == null) {
            return;
        }
        for (File file : fileList) {
            FileInfo fileInfo = FileInfo.fromFile(file, baseDir);
            if (file.isDirectory()) {
                FileUtils.listFilesRecursive(file, baseDir, files);
                continue;
            }
            files.add(fileInfo);
        }
    }

    public static String makeUniformPath(String path) {
        String res = path.replaceAll("\\\\", "/");
        if (res.startsWith("/")) {
            return res.substring(1);
        }
        return res;
    }

    public static Map<String, List<FileInfo>> calculateFileDifferences(List<FileInfo> sourceFiles, List<FileInfo> targetFiles, BackupType backupType) {
        HashMap<String, List<FileInfo>> result = new HashMap<String, List<FileInfo>>();
        Map<String, FileInfo> sourceMap = sourceFiles.stream().collect(Collectors.toMap(FileInfo::getRelativePath, f -> f));
        Map<String, FileInfo> targetMap = targetFiles.stream().collect(Collectors.toMap(FileInfo::getRelativePath, f -> f));
        List filesToTransfer = sourceFiles.stream().filter(sourceFile -> {
            if (sourceFile.isDirectory()) {
                return false;
            }
            FileInfo targetFile = (FileInfo)targetMap.get(sourceFile.getRelativePath());
            if (targetFile == null) {
                return true;
            }
            return !sourceFile.getModificationTime().equals(targetFile.getModificationTime()) || sourceFile.getSize() != targetFile.getSize();
        }).collect(Collectors.toList());
        result.put("transfer", filesToTransfer);
        if (backupType == BackupType.MIRROR) {
            List filesToDelete = targetFiles.stream().filter(targetFile -> !targetFile.isDirectory() && !sourceMap.containsKey(targetFile.getRelativePath())).collect(Collectors.toList());
            result.put("delete", filesToDelete);
        } else {
            result.put("delete", new ArrayList());
        }
        return result;
    }

    public static String getTargetPath(FileInfo file, String targetDir, BackupType backupType) {
        if (backupType != BackupType.DATE_SEPARATED) {
            return targetDir;
        }
        SimpleDateFormat dtf = new SimpleDateFormat("yyyy-MM-dd");
        String dateDir = dtf.format(new Date(file.getModificationTime().toEpochMilli()));
        return Paths.get(targetDir, dateDir).toString();
    }

    public static void createDirectoryIfNotExists(File directory) throws IOException {
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("Failed to create directory 8: " + directory);
        }
    }

    public static void setFileTimes(File file, Instant creationTime, Instant modificationTime) throws IOException {
        Path path = file.toPath();
        Files.setAttribute(path, "creationTime", FileTime.from(creationTime), new LinkOption[0]);
        Files.setAttribute(path, "lastModifiedTime", FileTime.from(modificationTime), new LinkOption[0]);
    }

    public static void setFileTimesToEpoch(File file) throws IOException {
        Instant epoch = Instant.EPOCH;
        FileUtils.setFileTimes(file, epoch, epoch);
    }

    public static void delete(File file) throws IOException {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File child : files) {
                FileUtils.delete(child);
            }
        }
        if (!file.delete()) {
            throw new IOException("Failed to delete: " + file);
        }
    }

    public static void copyFile(File source, File target) throws IOException {
        FileUtils.createDirectoryIfNotExists(target.getParentFile());
        Files.copy(source.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
        BasicFileAttributes attrs = Files.readAttributes(source.toPath(), BasicFileAttributes.class, new LinkOption[0]);
        FileUtils.setFileTimes(target, attrs.creationTime().toInstant(), attrs.lastModifiedTime().toInstant());
    }

    public static byte[] readFile(File file) throws IOException {
        return Files.readAllBytes(file.toPath());
    }

    public static void writeFile(File file, byte[] data) throws IOException {
        FileUtils.createDirectoryIfNotExists(file.getParentFile());
        Files.write(file.toPath(), data, new OpenOption[0]);
    }

    public static boolean deleteDirectoryContents(Path directory) throws IOException {
        if (!Files.exists(directory, new LinkOption[0]) || !Files.isDirectory(directory, new LinkOption[0])) {
            return false;
        }
        boolean success = true;
        try (Stream<Path> paths = Files.walk(directory, new FileVisitOption[0]);){
            List filesToDelete = paths.filter(path -> !path.equals(directory)).sorted((a, b) -> -a.compareTo((Path)b)).collect(Collectors.toList());
            for (Path path2 : filesToDelete) {
                try {
                    Files.delete(path2);
                }
                catch (IOException e) {
                    success = false;
                    log.error("Failed to delete: {} - {}", (Object)path2, (Object)e.getMessage());
                }
            }
        }
        Files.delete(directory);
        return success;
    }
}

