/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.lib.utils;

import java.util.function.BooleanSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sleeper {
    private static final Logger log = LoggerFactory.getLogger(Sleeper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sleep(long timeoutMillis) {
        try {
            Object obj;
            if (timeoutMillis == 0L) {
                Thread.onSpinWait();
                return;
            }
            Object object = obj = new Object();
            synchronized (object) {
                obj.wait(timeoutMillis);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sleep(long timeoutMillis, BooleanSupplier booleanSupplier) {
        try {
            Object obj = new Object();
            int times = (int)timeoutMillis;
            int counter = 100;
            if (times <= 100) {
                counter = 2;
            }
            int i = 0;
            while ((long)i < timeoutMillis) {
                Object object = obj;
                synchronized (object) {
                    obj.wait(counter);
                }
                if (booleanSupplier.getAsBoolean()) {
                    return;
                }
                i += counter;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new RuntimeException("Sleeper sleep timed out");
    }

    public static void sleepNoException(long timeoutMillis, BooleanSupplier booleanSupplier) {
        Sleeper.sleepNoException(timeoutMillis, booleanSupplier, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sleepNoException(long timeoutMillis, BooleanSupplier booleanSupplier, boolean silent) {
        try {
            Object obj = new Object();
            int times = (int)timeoutMillis / 100;
            for (int i = 0; i < 100; ++i) {
                Object object = obj;
                synchronized (object) {
                    obj.wait(times);
                }
                if (!booleanSupplier.getAsBoolean()) continue;
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!silent) {
            log.debug("Sleeper sleep timed out with no answer");
        }
    }

    public static void yield() {
        Thread.onSpinWait();
    }
}

