/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.client;

import java.io.IOException;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.UUID;
import org.kendar.sync.client.CommandLineArgs;
import org.kendar.sync.client.SyncClientBackup;
import org.kendar.sync.client.SyncClientRestore;
import org.kendar.sync.client.SyncClientSync;
import org.kendar.sync.lib.network.TcpConnection;
import org.kendar.sync.lib.protocol.BackupType;
import org.kendar.sync.lib.protocol.ConnectMessage;
import org.kendar.sync.lib.protocol.ConnectResponseMessage;
import org.kendar.sync.lib.protocol.Message;
import org.kendar.sync.lib.protocol.MessageType;
import org.kendar.sync.lib.protocol.SyncEndAckMessage;
import org.kendar.sync.lib.protocol.SyncEndMessage;
import org.kendar.sync.lib.utils.Sleeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncClient {
    public static final int DEFAULT_MAX_PACKET_SIZE = 0x100000;
    private static final int DEFAULT_MAX_CONNECTIONS = 5;
    private static final Logger log = LoggerFactory.getLogger(SyncClient.class);

    private boolean validateArgs(CommandLineArgs args) {
        boolean valid = true;
        if (args.getSourceFolder() == null) {
            log.error("[CLIENT] Source folder is required (--source)");
            valid = false;
        } else if (!Files.exists(Path.of(args.getSourceFolder(), new String[0]), new LinkOption[0])) {
            log.error("[CLIENT] Source folder does not exists (--source)");
            valid = false;
        }
        if (args.getTargetFolder() == null) {
            log.error("[CLIENT] Target folder is required (--target)");
            valid = false;
        }
        if (args.getServerAddress() == null) {
            log.error("[CLIENT] Server address is required (--server)");
            valid = false;
        }
        if (args.getUsername() == null) {
            log.error("[CLIENT] Username is required (--username)");
            valid = false;
        }
        if (args.getPassword() == null) {
            log.error("[CLIENT] Password is required (--password)");
            valid = false;
        }
        if (!valid) {
            log.error("\nUse --help for usage information");
        }
        return valid;
    }

    public void doSync(CommandLineArgs commandLineArgs) {
        if (!this.validateArgs(commandLineArgs)) {
            return;
        }
        try {
            log.debug("[CLIENT] Connecting to server {}:{}", (Object)commandLineArgs.getServerAddress(), (Object)commandLineArgs.getServerPort());
            if (commandLineArgs.isDryRun()) {
                log.debug("[CLIENT] Running in dry-run mode. No actual file operations will be performed.");
            }
            Socket socket = new Socket(commandLineArgs.getServerAddress(), commandLineArgs.getServerPort());
            UUID sessionId = UUID.randomUUID();
            try (TcpConnection connection = new TcpConnection(socket, sessionId, 0, 0x100000);){
                ConnectMessage connectMessage = new ConnectMessage(commandLineArgs.getUsername(), commandLineArgs.getPassword(), commandLineArgs.getTargetFolder(), 0x100000, 5, commandLineArgs.isDryRun(), commandLineArgs.getHostName());
                connection.sendMessage((Message)connectMessage);
                Message response = connection.receiveMessage();
                if (response.getMessageType() != MessageType.CONNECT_RESPONSE) {
                    log.error("[CLIENT] Unexpected response 1: {}", (Object)response.getMessageType());
                    return;
                }
                ConnectResponseMessage connectResponse = (ConnectResponseMessage)response;
                if (!connectResponse.isAccepted()) {
                    log.error("[CLIENT] Connection rejected: {}", (Object)connectResponse.getErrorMessage());
                    return;
                }
                connection.setSessionId(connectResponse.getSessionId());
                int maxConnections = Math.min(commandLineArgs.getMaxConnections(), connectResponse.getMaxConnections());
                int maxPacketSize = Math.min(commandLineArgs.getMaxSize(), connectResponse.getMaxPacketSize());
                if (maxConnections == 0) {
                    maxConnections = connectResponse.getMaxConnections();
                }
                if (maxPacketSize == 0) {
                    maxPacketSize = connectResponse.getMaxPacketSize();
                }
                log.debug("[CLIENT] Connected to server");
                if (connectResponse.getBackupType() == BackupType.TWO_WAY_SYNC) {
                    new SyncClientSync().performSync(connection, commandLineArgs, maxConnections, maxPacketSize);
                } else if (commandLineArgs.isBackup()) {
                    new SyncClientBackup().performBackup(connection, commandLineArgs, maxConnections, maxPacketSize);
                } else {
                    new SyncClientRestore().performRestore(connection, commandLineArgs, maxConnections, maxPacketSize);
                }
                Sleeper.sleep((long)200L);
                connection.sendMessage((Message)new SyncEndMessage());
                response = connection.receiveMessage();
                if (response == null || response.getMessageType() != MessageType.SYNC_END_ACK) {
                    log.warn("[CLIENT] Unexpected response 2: {}", (Object)response.getMessageType());
                    return;
                }
                SyncEndAckMessage syncEndAck = (SyncEndAckMessage)response;
                if (!syncEndAck.isSuccess()) {
                    log.error("[CLIENT] Sync failed: {}", (Object)syncEndAck.getErrorMessage());
                    return;
                }
                log.debug("[CLIENT] Sync completed successfully");
            }
        }
        catch (IOException e) {
            log.trace("[CLIENT] Error: {}", (Object)e.getMessage());
        }
    }
}

