/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.client;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.ArrayList;
import org.kendar.sync.client.CommandLineArgs;
import org.kendar.sync.client.SyncClient;
import org.kendar.sync.lib.protocol.BackupType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncClientApp {
    private static final Logger log = LoggerFactory.getLogger(SyncClientApp.class);

    public static void main(String[] args) {
        CommandLineArgs commandLineArgs = SyncClientApp.parseCommandLineArgs(args);
        if (commandLineArgs.isHelp()) {
            SyncClientApp.printHelp();
            return;
        }
        String hostname = SyncClientApp.getHostname();
        SyncClient syncClient = new SyncClient();
        commandLineArgs.setHostName(hostname);
        syncClient.doSync(commandLineArgs);
    }

    private static String getHostname() {
        ArrayList<String> hostnames = new ArrayList<String>();
        try {
            String inputLine;
            Runtime r = Runtime.getRuntime();
            Process p = r.exec("hostname");
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                String trimmed = inputLine.trim().toUpperCase();
                if (SyncClientApp.isValid(trimmed)) continue;
                hostnames.add(inputLine);
            }
            in.close();
        }
        catch (Exception ex) {
            log.trace("[SERVER] error on `hostname` call", (Throwable)ex);
        }
        try {
            String hostname = InetAddress.getLocalHost().getHostName().trim().toUpperCase();
            if (!SyncClientApp.isValid(hostname) && !hostnames.contains(hostname)) {
                hostnames.add(hostname);
            }
        }
        catch (Exception ex) {
            log.trace("[SERVER] error on getHostname", (Throwable)ex);
        }
        if (hostnames.isEmpty()) {
            hostnames.add("localhost");
        }
        return (String)hostnames.get(0);
    }

    private static boolean isValid(String trimmed) {
        return trimmed.isEmpty() || trimmed.equalsIgnoreCase("localhost") || trimmed.equalsIgnoreCase("127.0.0.1");
    }

    private static CommandLineArgs parseCommandLineArgs(String[] args) {
        CommandLineArgs commandLineArgs = new CommandLineArgs();
        block45: for (int i = 0; i < args.length; ++i) {
            String arg;
            switch (arg = args[i]) {
                case "--help": 
                case "-h": {
                    commandLineArgs.setHelp(true);
                    continue block45;
                }
                case "--source": 
                case "-s": {
                    if (i + 1 >= args.length) continue block45;
                    commandLineArgs.setSourceFolder(args[++i]);
                    continue block45;
                }
                case "--conn": 
                case "-c": {
                    if (i + 1 >= args.length) continue block45;
                    commandLineArgs.setMaxConnections(Integer.parseInt(args[++i]));
                    continue block45;
                }
                case "--size": 
                case "-z": {
                    if (i + 1 >= args.length) continue block45;
                    commandLineArgs.setMaxSize(Integer.parseInt(args[++i]));
                    continue block45;
                }
                case "--target": 
                case "-t": {
                    if (i + 1 >= args.length) continue block45;
                    commandLineArgs.setTargetFolder(args[++i]);
                    continue block45;
                }
                case "--backup": 
                case "-b": {
                    commandLineArgs.setBackup(true);
                    continue block45;
                }
                case "--restore": 
                case "-r": {
                    commandLineArgs.setBackup(false);
                    continue block45;
                }
                case "--server": {
                    if (i + 1 >= args.length) continue block45;
                    commandLineArgs.setServerAddress(args[++i]);
                    continue block45;
                }
                case "--port": 
                case "-p": {
                    if (i + 1 >= args.length) continue block45;
                    try {
                        commandLineArgs.setServerPort(Integer.parseInt(args[++i]));
                    }
                    catch (NumberFormatException e) {
                        log.error("[CLIENT] Invalid port number: {}", (Object)args[i]);
                    }
                    continue block45;
                }
                case "--username": 
                case "-u": {
                    if (i + 1 >= args.length) continue block45;
                    commandLineArgs.setUsername(args[++i]);
                    continue block45;
                }
                case "--password": 
                case "-pw": {
                    if (i + 1 >= args.length) continue block45;
                    commandLineArgs.setPassword(args[++i]);
                    continue block45;
                }
                case "--dry-run": 
                case "-d": {
                    commandLineArgs.setDryRun(true);
                    continue block45;
                }
                case "--type": {
                    if (i + 1 >= args.length) continue block45;
                    String typeArg = args[++i].toUpperCase();
                    try {
                        commandLineArgs.setBackupType(BackupType.valueOf((String)typeArg));
                        continue block45;
                    }
                    catch (IllegalArgumentException e) {
                        log.error("[CLIENT] Invalid backup type: {}", (Object)typeArg);
                        log.error("[CLIENT] Valid types are: PRESERVE, MIRROR, DATE_SEPARATED");
                    }
                }
            }
        }
        return commandLineArgs;
    }

    private static void printHelp() {
        System.out.println("Usage: java -jar sync-client.jar [options]");
        System.out.println("Options:");
        System.out.println("  --help, -h                  Show this help message");
        System.out.println("  --source, -s <folder>       Source folder");
        System.out.println("  --target, -t <folder>       Target folder (virtual folder on server)");
        System.out.println("  --backup, -b                Perform backup (default)");
        System.out.println("  --restore, -r               Perform restore");
        System.out.println("  --conn, -c                  Max connections");
        System.out.println("  --size, -z                  Max packet size in bytes");
        System.out.println("  --server <address>          Server address");
        System.out.println("  --port, -p <port>           Server port (default: 8090)");
        System.out.println("  --username, -u <username>   Username for authentication");
        System.out.println("  --password, -pw <password>  Password for authentication");
        System.out.println("  --dry-run, -d               Perform a dry run (no actual file operations)");
        System.out.println("  --type <type>               Backup type: PRESERVE, MIRROR, DATE_SEPARATED (default: PRESERVE)");
    }
}

