/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.client;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.kendar.sync.client.BaseSyncClientProcess;
import org.kendar.sync.client.CommandLineArgs;
import org.kendar.sync.lib.model.FileInfo;
import org.kendar.sync.lib.network.TcpConnection;
import org.kendar.sync.lib.protocol.FileListMessage;
import org.kendar.sync.lib.protocol.FileListResponseMessage;
import org.kendar.sync.lib.protocol.Message;
import org.kendar.sync.lib.protocol.MessageType;
import org.kendar.sync.lib.protocol.StartRestore;
import org.kendar.sync.lib.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncClientRestore
extends BaseSyncClientProcess {
    private static final Logger log = LoggerFactory.getLogger(SyncClientRestore.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performRestore(TcpConnection connection, CommandLineArgs args, int maxConnections, int maxPacketSize) throws IOException {
        log.debug("[CLIENT] Starting restore from {} to {}", (Object)args.getTargetFolder(), (Object)args.getSourceFolder());
        ArrayList<FileInfo> files = new ArrayList<FileInfo>();
        File sourceDir = new File(args.getSourceFolder());
        if (!sourceDir.exists() || !sourceDir.isDirectory()) {
            log.error("[CLIENT] 1 Source folder does not exist or is not a directory");
            return;
        }
        this.scanDirectory(sourceDir, sourceDir.getAbsolutePath(), files, args.isIgnoreHiddenFiles(), args.isIgnoreSystemFiles());
        log.debug("[CLIENT] 2 Found {} files to backup", (Object)files.size());
        FileListMessage fileListMessage = new FileListMessage(files, args.isBackup(), 1, 1);
        connection.sendMessage((Message)fileListMessage);
        Message response = connection.receiveMessage();
        if (response.getMessageType() != MessageType.FILE_LIST_RESPONSE) {
            log.error("[CLIENT] Unexpected response 6: {}", (Object)response.getMessageType());
            return;
        }
        FileListResponseMessage fileListResponse = (FileListResponseMessage)response;
        new Thread(() -> {
            for (String relativePath : fileListResponse.getFilesToDelete()) {
                File fileToDelete = new File(args.getSourceFolder(), relativePath);
                if (!args.isDryRun()) {
                    if (fileToDelete.exists() && !fileToDelete.delete()) {
                        continue;
                    }
                } else {
                    log.debug("[CLIENT] Dry run: Would delete file {}", (Object)fileToDelete.getAbsolutePath());
                }
                log.debug("[CLIENT] Deleted file: {}", (Object)relativePath);
            }
        }).start();
        Map<String, FileInfo> mapToTransferInitial = fileListResponse.getFilesToTransfer().stream().collect(Collectors.toMap(fileInfo -> FileUtils.makeUniformPath((String)fileInfo.getRelativePath()), fileInfo -> fileInfo));
        ConcurrentHashMap<String, FileInfo> mapToTransfer = new ConcurrentHashMap<String, FileInfo>(mapToTransferInitial);
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(maxConnections, maxConnections, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        CountDownLatch completionLatch = new CountDownLatch(mapToTransfer.size());
        ConcurrentLinkedQueue<TcpConnection> connections = new ConcurrentLinkedQueue<TcpConnection>();
        Semaphore semaphore = new Semaphore(maxConnections);
        for (int i = 0; i < maxConnections; ++i) {
            TcpConnection subConnection = this.getTcpConnection(connection, args, i, maxPacketSize);
            connections.add(subConnection);
            StartRestore startRestoreMessage2 = new StartRestore();
            startRestoreMessage2.initialize(subConnection.getConnectionId(), subConnection.getSessionId(), 0);
            subConnection.sendMessage((Message)startRestoreMessage2);
            Message message = subConnection.receiveMessage();
            if (message.getMessageType() == MessageType.START_RESTORE_ACK) continue;
            log.error("[CLIENT] Unexpected message 5: {}", (Object)message.getMessageType());
            throw new IOException("Unexpected message 5: " + message.getMessageType());
        }
        StartRestore startRestoreMessage = new StartRestore();
        startRestoreMessage.initialize(connection.getConnectionId(), connection.getSessionId(), 0);
        connection.sendMessage((Message)startRestoreMessage);
        Message message = connection.receiveMessage();
        if (message.getMessageType() != MessageType.START_RESTORE_ACK) {
            log.error("[CLIENT] Unexpected message 6: {}", (Object)message.getMessageType());
            throw new IOException("Unexpected message 6: " + message.getMessageType());
        }
        while (!mapToTransfer.isEmpty()) {
            try {
                semaphore.acquire();
            }
            catch (InterruptedException startRestoreMessage2) {
                // empty catch block
            }
            executorService.submit(() -> this.performSingleFileRestore(args, connections, mapToTransfer, semaphore, completionLatch));
        }
        try {
            completionLatch.await();
            log.debug("[CLIENT] All file transfers completed 1");
            connection.close();
        }
        catch (InterruptedException e) {
            log.error("[CLIENT] File transfer interrupted 1: {}", (Object)e.getMessage());
        }
        finally {
            executorService.shutdown();
        }
    }
}

