/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.lib.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.kendar.sync.lib.protocol.BackupType;

public class ServerSettings {
    private int port;
    private int webPort;
    private int maxPacketSize;
    private int maxConnections;
    private List<User> users;
    private List<BackupFolder> backupFolders;

    public ServerSettings() {
        this.users = new ArrayList<User>();
        this.backupFolders = new ArrayList<BackupFolder>();
    }

    public ServerSettings(int port, int webPort, int maxPacketSize, int maxConnections, List<User> users, List<BackupFolder> backupFolders) {
        this.port = port;
        this.webPort = webPort;
        this.maxPacketSize = maxPacketSize;
        this.maxConnections = maxConnections;
        this.users = users;
        this.backupFolders = backupFolders;
    }

    public static ServerSettings load(String filePath) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        Path path = Paths.get(filePath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            ServerSettings settings = new ServerSettings();
            settings.setPort(8090);
            settings.setWebPort(8089);
            settings.setMaxPacketSize(0x100000);
            settings.setMaxConnections(5);
            User adminUser = new User(UUID.randomUUID().toString(), "admin", "admin", true);
            settings.getUsers().add(adminUser);
            settings.save(filePath);
            return settings;
        }
        return (ServerSettings)mapper.readValue(path.toFile(), ServerSettings.class);
    }

    public void save(String filePath) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        File file = new File(filePath);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        mapper.writerWithDefaultPrettyPrinter().writeValue(file, (Object)this);
    }

    @JsonIgnore
    public Optional<User> authenticate(String username, String password) {
        return this.users.stream().filter(user -> user.getUsername().equals(username) && user.getPassword().equals(password)).findFirst();
    }

    @JsonIgnore
    public Optional<BackupFolder> getUserFolder(String userId, String folderName) {
        return this.backupFolders.stream().filter(folder -> folder.getVirtualName().equals(folderName) && folder.getAllowedUsers().contains(userId)).findFirst();
    }

    public int getWebPort() {
        return this.webPort;
    }

    public void setWebPort(int webPort) {
        this.webPort = webPort;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public void setMaxPacketSize(int maxPacketSize) {
        this.maxPacketSize = maxPacketSize;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public List<User> getUsers() {
        return this.users;
    }

    public void setUsers(List<User> users) {
        this.users = users;
    }

    public List<BackupFolder> getBackupFolders() {
        return this.backupFolders;
    }

    public void setBackupFolders(List<BackupFolder> backupFolders) {
        this.backupFolders = backupFolders;
    }

    public static class User {
        private String id;
        private String username;
        private String password;
        private boolean admin;

        public User() {
        }

        public User(String id, String username, String password, boolean admin) {
            this.id = id;
            this.username = username;
            this.password = password;
            this.admin = admin;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public boolean isAdmin() {
            return this.admin;
        }

        public void setAdmin(boolean admin) {
            this.admin = admin;
        }
    }

    public static class BackupFolder {
        private String virtualName;
        private String realPath;
        private BackupType backupType;
        private List<String> allowedUsers;

        public BackupFolder() {
            this.allowedUsers = new ArrayList<String>();
        }

        public BackupFolder(String virtualName, String realPath, BackupType backupType, List<String> allowedUsers) {
            this.virtualName = virtualName;
            this.realPath = realPath;
            this.backupType = backupType;
            this.allowedUsers = allowedUsers;
        }

        public String getVirtualName() {
            return this.virtualName;
        }

        public void setVirtualName(String virtualName) {
            this.virtualName = virtualName;
        }

        public String getRealPath() {
            return this.realPath;
        }

        public void setRealPath(String realPath) {
            this.realPath = realPath;
        }

        public BackupType getBackupType() {
            return this.backupType;
        }

        public void setBackupType(BackupType backupType) {
            this.backupType = backupType;
        }

        public List<String> getAllowedUsers() {
            return this.allowedUsers;
        }

        public void setAllowedUsers(List<String> allowedUsers) {
            this.allowedUsers = allowedUsers;
        }
    }
}

