/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.lib.model;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;
import org.kendar.sync.lib.utils.Attributes;
import org.kendar.sync.lib.utils.FileUtils;

public class FileInfo {
    private String path;
    private String relativePath;
    private long size;
    private Instant creationTime;
    private Instant modificationTime;
    private int extendedUmask;

    public FileInfo() {
    }

    public FileInfo(String path, String relativePath, long size, Instant creationTime, Instant modificationTime, int extendedUmask) {
        this.path = path;
        this.relativePath = relativePath;
        this.size = size;
        this.creationTime = creationTime;
        this.modificationTime = modificationTime;
        this.extendedUmask = extendedUmask;
    }

    public static FileInfo fromFile(File file, String baseDir) throws IOException {
        Path filePath = file.toPath();
        Path basePath = Paths.get(baseDir, new String[0]).toAbsolutePath();
        Path relativePath = basePath.relativize(filePath.toAbsolutePath());
        Attributes attrs = FileUtils.readFileAttributes(filePath);
        return new FileInfo(file.getAbsolutePath(), FileUtils.makeUniformPath(relativePath.toString()), file.length(), attrs.getCreationTime(), attrs.getModificationTime(), attrs.getExtendedUmask());
    }

    public static FileInfo fromLine(String fileLine) {
        try {
            String[] parts = fileLine.split("\t");
            if (parts.length < 5) {
                throw new IllegalArgumentException("Invalid file line format: " + fileLine);
            }
            SimpleDateFormat dtf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            String relativePath = parts[0];
            long size = Long.parseLong(parts[1]);
            Instant creationTime = dtf.parse(parts[2]).toInstant();
            Instant modificationTime = dtf.parse(parts[3]).toInstant();
            int extendedUmask = Integer.parseInt(parts[4]);
            return new FileInfo(null, relativePath, size, creationTime, modificationTime, extendedUmask);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public File toFile(String baseDir) {
        return new File(baseDir, this.relativePath);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
    }

    public Instant getModificationTime() {
        return this.modificationTime;
    }

    public void setModificationTime(Instant modificationTime) {
        this.modificationTime = modificationTime;
    }

    public int getExtendedUmask() {
        return this.extendedUmask;
    }

    public void setExtendedUmask(int extendedUmask) {
        this.extendedUmask = extendedUmask;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileInfo fileInfo = (FileInfo)o;
        return Objects.equals(this.relativePath, fileInfo.relativePath);
    }

    public int hashCode() {
        return Objects.hash(this.relativePath);
    }

    public String toString() {
        return "FileInfo{relativePath='" + this.relativePath + "', size=" + this.size + ", modificationTime=" + this.modificationTime + "}";
    }

    public String toLine() {
        SimpleDateFormat dtf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        return String.join((CharSequence)"\t", this.relativePath, String.valueOf(this.size), dtf.format(new Date(this.creationTime.toEpochMilli())), dtf.format(new Date(this.modificationTime.toEpochMilli())), String.valueOf(this.extendedUmask));
    }
}

