/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.lib.protocol;

import org.kendar.sync.lib.buffer.ByteContainer;
import org.kendar.sync.lib.protocol.Message;
import org.kendar.sync.lib.protocol.MessageType;

public class ErrorMessage
extends Message {
    private String errorCode;
    private String errorMessage;
    private String details;

    public ErrorMessage() {
    }

    public ErrorMessage(String errorCode, String errorMessage, String details) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.details = details;
    }

    public ErrorMessage(String errorCode, String errorMessage) {
        this(errorCode, errorMessage, null);
    }

    public static ErrorMessage fromException(String errorCode, Exception exception) {
        return new ErrorMessage(errorCode, exception.getMessage(), exception.toString());
    }

    @Override
    public MessageType getMessageType() {
        return MessageType.ERROR;
    }

    @Override
    protected Message deserialize(ByteContainer buffer) {
        this.errorCode = buffer.readType(String.class);
        this.errorMessage = buffer.readType(String.class);
        this.details = buffer.readType(String.class);
        return this;
    }

    @Override
    protected void serialize(ByteContainer buffer) {
        buffer.writeType(this.errorCode);
        if (this.errorMessage != null) {
            buffer.writeType(this.errorMessage);
        } else {
            buffer.writeType("");
        }
        if (this.details != null) {
            buffer.writeType(this.details);
        } else {
            buffer.writeType("");
        }
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    static {
        Message.registerMessageType(ErrorMessage.class);
    }
}

