/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.lib.protocol;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.kendar.sync.lib.buffer.ByteContainer;
import org.kendar.sync.lib.protocol.Message;
import org.kendar.sync.lib.protocol.MessageType;
import org.kendar.sync.lib.twoway.LogEntry;

public class FileSyncMessage
extends Message {
    private int partNumber;
    private int totalParts;
    private List<LogEntry> changes = new ArrayList<LogEntry>();
    private Instant lastlyUpdateTime;

    @Override
    public MessageType getMessageType() {
        return MessageType.FILE_SYNC;
    }

    @Override
    protected Message deserialize(ByteContainer buffer) {
        String[] filesLines = buffer.readType(String.class).split("\n");
        this.changes = new ArrayList<LogEntry>();
        for (String fileLine : filesLines) {
            if (fileLine.isEmpty()) continue;
            this.changes.add(LogEntry.fromLine(fileLine));
        }
        this.partNumber = buffer.readType(Integer.class);
        this.totalParts = buffer.readType(Integer.class);
        return this;
    }

    @Override
    protected void serialize(ByteContainer buffer) {
        List filesLines = this.changes.stream().map(LogEntry::toLine).collect(Collectors.toList());
        buffer.writeType(String.join((CharSequence)"\n", filesLines));
        buffer.writeType(this.partNumber);
        buffer.writeType(this.totalParts);
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(int partNumber) {
        this.partNumber = partNumber;
    }

    public int getTotalParts() {
        return this.totalParts;
    }

    public void setTotalParts(int totalParts) {
        this.totalParts = totalParts;
    }

    public List<LogEntry> getChanges() {
        return this.changes;
    }

    public void setChanges(List<LogEntry> changes) {
        this.changes = changes;
    }

    public Instant getLastlyUpdateTime() {
        return this.lastlyUpdateTime;
    }

    public void setLastlyUpdateTime(Instant lastlyUpdateTime) {
        this.lastlyUpdateTime = lastlyUpdateTime;
    }

    static {
        Message.registerMessageType(FileSyncMessage.class);
    }
}

