/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.lib.protocol;

public enum MessageType {
    CONNECT("CN"),
    CONNECT_RESPONSE("CR"),
    FILE_LIST("FL"),
    FILE_LIST_RESPONSE("FR"),
    FILE_DESCRIPTOR("FD"),
    FILE_DESCRIPTOR_ACK("FA"),
    FILE_DATA("FT"),
    FILE_END("FE"),
    FILE_END_ACK("EA"),
    SYNC_END("SE"),
    SYNC_END_ACK("SA"),
    ERROR("ER"),
    START_RESTORE("RS"),
    START_RESTORE_ACK("RK"),
    FILE_DATA_ACK("FK"),
    FILE_SYNC("SY"),
    FILE_SYNC_ACK("SK");

    private final String code;

    private MessageType(String code) {
        if (code == null || code.length() != 2) {
            throw new IllegalArgumentException("Message type code must be exactly 2 characters");
        }
        this.code = code;
    }

    public static MessageType fromCode(String code) {
        for (MessageType type : MessageType.values()) {
            if (!type.code.equals(code)) continue;
            return type;
        }
        return null;
    }

    public String getCode() {
        return this.code;
    }
}

