/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.lib.protocol;

import org.kendar.sync.lib.buffer.ByteContainer;
import org.kendar.sync.lib.protocol.Message;
import org.kendar.sync.lib.protocol.MessageType;

public class SyncEndAckMessage
extends Message {
    private boolean success;
    private String errorMessage;

    public SyncEndAckMessage() {
    }

    public SyncEndAckMessage(boolean success, String errorMessage) {
        this.success = success;
        this.errorMessage = errorMessage;
    }

    public static SyncEndAckMessage success() {
        return new SyncEndAckMessage(true, null);
    }

    public static SyncEndAckMessage failure(String errorMessage) {
        return new SyncEndAckMessage(false, errorMessage);
    }

    @Override
    public MessageType getMessageType() {
        return MessageType.SYNC_END_ACK;
    }

    @Override
    protected Message deserialize(ByteContainer buffer) {
        this.success = buffer.readType(Boolean.class);
        this.errorMessage = buffer.readType(String.class);
        return this;
    }

    @Override
    protected void serialize(ByteContainer buffer) {
        buffer.writeType(this.success);
        buffer.writeType(this.errorMessage);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    static {
        Message.registerMessageType(SyncEndAckMessage.class);
    }
}

