/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.client;

import java.io.IOException;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Timer;
import java.util.UUID;
import org.kendar.sync.client.CommandLineArgs;
import org.kendar.sync.client.SyncClientBackup;
import org.kendar.sync.client.SyncClientRestore;
import org.kendar.sync.client.SyncClientSync;
import org.kendar.sync.lib.network.TcpConnection;
import org.kendar.sync.lib.protocol.BackupType;
import org.kendar.sync.lib.protocol.ConnectMessage;
import org.kendar.sync.lib.protocol.ConnectResponseMessage;
import org.kendar.sync.lib.protocol.KeepAlive;
import org.kendar.sync.lib.protocol.Message;
import org.kendar.sync.lib.protocol.MessageType;
import org.kendar.sync.lib.protocol.SyncEndAckMessage;
import org.kendar.sync.lib.protocol.SyncEndMessage;
import org.kendar.sync.lib.utils.Sleeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncClient {
    public static final int DEFAULT_MAX_PACKET_SIZE = 0x100000;
    private static final int DEFAULT_MAX_CONNECTIONS = 5;
    private static final Logger log = LoggerFactory.getLogger(SyncClient.class);
    private Timer timer;
    private Socket socket;
    private int keepAlive = -1;
    private boolean isRunning = true;

    public void setKeepAlive(int keepAlive) {
        this.keepAlive = keepAlive;
    }

    private boolean validateArgs(CommandLineArgs args) {
        boolean valid = true;
        if (args.getSourceFolder() == null) {
            log.error("[CLIENT] Source folder is required (--source)");
            valid = false;
        } else if (!Files.exists(Path.of(args.getSourceFolder(), new String[0]), new LinkOption[0])) {
            log.error("[CLIENT] Source folder does not exists (--source)");
            valid = false;
        }
        if (args.getTargetFolder() == null) {
            log.error("[CLIENT] Target folder is required (--target)");
            valid = false;
        }
        if (args.getServerAddress() == null) {
            log.error("[CLIENT] Server address is required (--server)");
            valid = false;
        }
        if (args.getUsername() == null) {
            log.error("[CLIENT] Username is required (--username)");
            valid = false;
        }
        if (args.getPassword() == null) {
            log.error("[CLIENT] Password is required (--password)");
            valid = false;
        }
        if (!valid) {
            log.error("\nUse --help for usage information");
        }
        return valid;
    }

    public void disconnect() {
        this.isRunning = false;
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void doSync(CommandLineArgs commandLineArgs) {
        if (!this.validateArgs(commandLineArgs)) {
            return;
        }
        try {
            log.debug("[CLIENT] Connecting to server {}:{}", (Object)commandLineArgs.getServerAddress(), (Object)commandLineArgs.getServerPort());
            if (commandLineArgs.isDryRun()) {
                log.debug("[CLIENT] Running in dry-run mode. No actual file operations will be performed.");
            }
            this.socket = new Socket(commandLineArgs.getServerAddress(), commandLineArgs.getServerPort());
            UUID sessionId = UUID.randomUUID();
            int maxPacketSize = 0x100000;
            if (commandLineArgs.getMaxSize() == 0) {
                maxPacketSize = commandLineArgs.getMaxSize();
            }
            try (TcpConnection connection = new TcpConnection(this.socket, sessionId, 0, maxPacketSize);){
                ConnectMessage connectMessage = new ConnectMessage(commandLineArgs.getUsername(), commandLineArgs.getPassword(), commandLineArgs.getTargetFolder(), 0x100000, 5, commandLineArgs.isDryRun(), commandLineArgs.getHostName(), commandLineArgs.isIgnoreSystemFiles(), commandLineArgs.isIgnoreHiddenFiles(), commandLineArgs.getIgnoredPatterns() != null ? commandLineArgs.getIgnoredPatterns() : List.of());
                connection.sendMessage(connectMessage);
                Message response = connection.receiveMessage();
                if (response.getMessageType() != MessageType.CONNECT_RESPONSE) {
                    log.error("[CLIENT] Unexpected response 1: {}", (Object)response.getMessageType());
                    return;
                }
                ConnectResponseMessage connectResponse = (ConnectResponseMessage)response;
                if (!connectResponse.isAccepted()) {
                    log.error("[CLIENT] Connection rejected: {}", (Object)connectResponse.getErrorMessage());
                    return;
                }
                long keepAlive = 3000L;
                if (this.keepAlive > 0) {
                    keepAlive = this.keepAlive;
                }
                this.timer = new Timer("idle-timeout-task", true);
                this.timer.schedule((java.util.TimerTask)new TimerTask(connection, this.timer), keepAlive, keepAlive);
                connection.setSessionId(connectResponse.getSessionId());
                int maxConnections = Math.min(commandLineArgs.getMaxConnections(), connectResponse.getMaxConnections());
                maxPacketSize = Math.min(commandLineArgs.getMaxSize(), connectResponse.getMaxPacketSize());
                connection.setMaxPacketSize(maxPacketSize);
                if (maxConnections == 0) {
                    maxConnections = connectResponse.getMaxConnections();
                }
                if (maxPacketSize == 0) {
                    maxPacketSize = connectResponse.getMaxPacketSize();
                }
                log.debug("[CLIENT] Connected to server");
                if (connectResponse.getBackupType() == BackupType.TWO_WAY_SYNC) {
                    ((SyncClientSync)new SyncClientSync().setCheckRunning(() -> this.isRunning)).performSync(connection, commandLineArgs, maxConnections, maxPacketSize, connectResponse.isIgnoreSystemFiles(), connectResponse.isIgnoreHiddenFiles(), connectResponse.getIgnoredPatterns());
                } else if (commandLineArgs.isBackup()) {
                    ((SyncClientBackup)new SyncClientBackup().setCheckRunning(() -> this.isRunning)).performBackup(connection, commandLineArgs, maxConnections, maxPacketSize, connectResponse.isIgnoreSystemFiles(), connectResponse.isIgnoreHiddenFiles(), connectResponse.getIgnoredPatterns());
                } else {
                    ((SyncClientRestore)new SyncClientRestore().setCheckRunning(() -> this.isRunning)).performRestore(connection, commandLineArgs, maxConnections, maxPacketSize, connectResponse.isIgnoreSystemFiles(), connectResponse.isIgnoreHiddenFiles(), connectResponse.getIgnoredPatterns());
                }
                Sleeper.sleep(200L);
                log.debug("[CLIENT] Completed main operation, shutting down");
                connection.sendMessage(new SyncEndMessage());
                log.debug("[CLIENT-{}] Waiting for end ", (Object)connection.getConnectionId());
                response = connection.receiveMessage();
                if (response == null || response.getMessageType() != MessageType.SYNC_END_ACK) {
                    log.warn("[CLIENT] Unexpected response 2: {}", (Object)response.getMessageType());
                    return;
                }
                SyncEndAckMessage syncEndAck = (SyncEndAckMessage)response;
                if (!syncEndAck.isSuccess()) {
                    log.error("[CLIENT] Sync failed: {}", (Object)syncEndAck.getErrorMessage());
                    return;
                }
                log.debug("[CLIENT] Shutting down");
                Sleeper.sleep(100L);
                connection.close();
                this.timer.cancel();
                log.debug("[CLIENT] Sync completed successfully");
            }
        }
        catch (IOException e) {
            log.trace("[CLIENT] Error: {}", (Object)e.getMessage());
        }
    }

    public class TimerTask
    extends java.util.TimerTask {
        private final Timer timer;
        private final TcpConnection mainConnection;

        public TimerTask(TcpConnection mainConnection, Timer timer) {
            this.mainConnection = mainConnection;
            this.timer = timer;
        }

        @Override
        public void run() {
            if (this.mainConnection != null) {
                try {
                    if (!this.mainConnection.isClosed()) {
                        log.debug("[CLIENT-{}] KEEPALIVE", (Object)this.mainConnection.getConnectionId());
                        this.mainConnection.sendMessage(new KeepAlive());
                    }
                }
                catch (Exception e) {
                    log.error("[CLIENT-{}] KEEPALIVE", (Object)this.mainConnection.getConnectionId(), (Object)e);
                    this.timer.cancel();
                }
            }
        }
    }
}

