/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.client;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.kendar.sync.client.BaseSyncClientProcess;
import org.kendar.sync.client.CommandLineArgs;
import org.kendar.sync.lib.model.FileInfo;
import org.kendar.sync.lib.network.TcpConnection;
import org.kendar.sync.lib.protocol.FileListMessage;
import org.kendar.sync.lib.protocol.FileListResponseMessage;
import org.kendar.sync.lib.protocol.Message;
import org.kendar.sync.lib.protocol.MessageType;
import org.kendar.sync.lib.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncClientBackup
extends BaseSyncClientProcess<SyncClientBackup> {
    private final Logger log = LoggerFactory.getLogger(SyncClientBackup.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performBackup(TcpConnection connection, CommandLineArgs args, int maxConnections, int maxPacketSize, boolean ignoreSystemFiles, boolean ignoreHiddenFiles, List<String> patternsToIgnore) throws IOException {
        this.log.debug("[CLIENT] Starting backup 2 from {} to {}", (Object)args.getSourceFolder(), (Object)args.getTargetFolder());
        ArrayList<FileInfo> files = new ArrayList<FileInfo>();
        File sourceDir = new File(args.getSourceFolder());
        if (!sourceDir.exists() || !sourceDir.isDirectory()) {
            this.log.error("[CLIENT] 3 Source folder does not exist or is not a directory");
            return;
        }
        this.scanDirectory(sourceDir, sourceDir.getAbsolutePath(), files, args.isIgnoreHiddenFiles(), args.isIgnoreSystemFiles());
        this.log.debug("[CLIENT] 4 Found {} files to backup", (Object)files.size());
        FileListMessage fileListMessage = new FileListMessage(files, args.isBackup(), 1, 1);
        connection.sendMessage(fileListMessage);
        Message response = connection.receiveMessage();
        if (response.getMessageType() != MessageType.FILE_LIST_RESPONSE) {
            this.log.error("[CLIENT] Unexpected response 3: {}", (Object)response.getMessageType());
            return;
        }
        FileListResponseMessage fileListResponse = (FileListResponseMessage)response;
        Map<String, FileInfo> mapToTransfer = fileListResponse.getFilesToTransfer().stream().collect(Collectors.toMap(fileInfo -> FileUtils.makeUniformPath(fileInfo.getRelativePath()), fileInfo -> fileInfo));
        List filesToTransfer = files.stream().filter(file -> mapToTransfer.containsKey(FileUtils.makeUniformPath(file.getRelativePath()))).collect(Collectors.toList());
        this.log.debug("[CLIENT] Transferring {} files with {} parallel connections", (Object)filesToTransfer.size(), (Object)maxConnections);
        this.executorService = new ThreadPoolExecutor(maxConnections, maxConnections, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        CountDownLatch completionLatch = new CountDownLatch(filesToTransfer.size());
        ConcurrentLinkedQueue<TcpConnection> connections = new ConcurrentLinkedQueue<TcpConnection>();
        Semaphore semaphore = new Semaphore(maxConnections);
        for (int i = 0; i < maxConnections; ++i) {
            TcpConnection subConnection = this.getTcpConnection(connection, args, i, maxPacketSize);
            connections.add(subConnection);
        }
        for (FileInfo file2 : filesToTransfer) {
            this.executorService.submit(() -> {
                TcpConnection currentConnection = null;
                try {
                    semaphore.acquire();
                    if (!this.isRunning()) {
                        this.close();
                        this.log.debug("[CLIENT-{}] Client stopped 1", (Object)connection.getConnectionId());
                        return;
                    }
                    currentConnection = (TcpConnection)connections.poll();
                    if (currentConnection == null) {
                        throw new RuntimeException("[CLIENT] No connection available");
                    }
                    this.log.debug("[CLIENT-{}] transferring file {}", (Object)currentConnection.getConnectionId(), (Object)file2.getRelativePath());
                    this.transferFile(file2, args, currentConnection);
                }
                catch (Exception e) {
                    this.log.error("[CLIENT] Error transferring file 2 {}: {}", (Object)file2.getRelativePath(), (Object)e.getMessage());
                }
                finally {
                    if (currentConnection != null) {
                        connections.add(currentConnection);
                    }
                    semaphore.release();
                    completionLatch.countDown();
                }
            });
        }
        try {
            completionLatch.await();
            this.log.debug("[CLIENT] All file transfers completed 3");
        }
        catch (InterruptedException e) {
            this.log.error("[CLIENT] File transfer interrupted 2: {}", (Object)e.getMessage());
        }
        finally {
            this.executorService.shutdown();
        }
    }
}

