/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.client;

import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.kendar.sync.client.BaseSyncClientProcess;
import org.kendar.sync.client.CommandLineArgs;
import org.kendar.sync.lib.model.FileInfo;
import org.kendar.sync.lib.network.TcpConnection;
import org.kendar.sync.lib.protocol.FileListResponseMessage;
import org.kendar.sync.lib.protocol.FileSyncMessage;
import org.kendar.sync.lib.protocol.FileSyncMessageAck;
import org.kendar.sync.lib.protocol.Message;
import org.kendar.sync.lib.protocol.MessageType;
import org.kendar.sync.lib.protocol.StartRestore;
import org.kendar.sync.lib.twoway.LogEntry;
import org.kendar.sync.lib.twoway.StatusAnalyzer;
import org.kendar.sync.lib.utils.FileUtils;
import org.kendar.sync.lib.utils.Sleeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncClientSync
extends BaseSyncClientProcess<SyncClientSync> {
    private static final Logger log = LoggerFactory.getLogger(SyncClientSync.class);
    private AtomicInteger counter = new AtomicInteger(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performSync(TcpConnection connection, CommandLineArgs args, int maxConnections, int maxPacketSize, boolean ignoreSystemFiles, boolean ignoreHiddenFiles, List<String> patternsToIgnore) throws IOException {
        log.debug("[CLIENT] Starting backup 1 from {} to {}", (Object)args.getSourceFolder(), (Object)args.getTargetFolder());
        ArrayList files = new ArrayList();
        File sourceDir = new File(args.getSourceFolder());
        if (!sourceDir.exists() || !sourceDir.isDirectory()) {
            log.error("[CLIENT] 3 Source folder does not exist or is not a directory");
            return;
        }
        StatusAnalyzer statusAnalyzer = new StatusAnalyzer(sourceDir.toString());
        List<LogEntry> changes = statusAnalyzer.analyze();
        Optional<Instant> lastUpdateTime = statusAnalyzer.getLastUpdateTime();
        if (lastUpdateTime.isEmpty()) {
            lastUpdateTime = Optional.of(Instant.now());
        }
        FileSyncMessage fileSyncMessage = new FileSyncMessage();
        fileSyncMessage.setChanges(changes);
        fileSyncMessage.setLastlyUpdateTime(lastUpdateTime.get());
        connection.sendMessage(fileSyncMessage);
        Message response = connection.receiveMessage();
        if (response == null) {
            log.error("[CLIENT] No response received from server");
            return;
        }
        if (response.getMessageType() != MessageType.FILE_LIST_RESPONSE) {
            log.error("[CLIENT] Unexpected response 3: {}", (Object)response.getMessageType());
            return;
        }
        FileListResponseMessage fileListResponse = (FileListResponseMessage)response;
        List<FileInfo> filesToTransfer = fileListResponse.getFilesToTransfer();
        new Thread(() -> {
            for (String relativePath : fileListResponse.getFilesToDelete()) {
                File fileToDelete = new File(args.getSourceFolder(), relativePath);
                if (!args.isDryRun()) {
                    if (fileToDelete.exists() && !fileToDelete.delete()) {
                        continue;
                    }
                } else {
                    log.debug("[CLIENT] Dry run: Would delete file {}", (Object)fileToDelete.getAbsolutePath());
                }
                log.debug("[CLIENT] Deleted file: {}", (Object)relativePath);
            }
        }).start();
        log.debug("[CLIENT] Transferring {} files with {} parallel connections", (Object)filesToTransfer.size(), (Object)maxConnections);
        this.executorService = new ThreadPoolExecutor(maxConnections, maxConnections, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        CountDownLatch completionLatch = new CountDownLatch(filesToTransfer.size());
        ConcurrentLinkedQueue<TcpConnection> connections = new ConcurrentLinkedQueue<TcpConnection>();
        Semaphore semaphore = new Semaphore(maxConnections);
        for (int i = 0; i < maxConnections; ++i) {
            TcpConnection subConnection = this.getTcpConnection(connection, args, i, maxPacketSize);
            connections.add(subConnection);
        }
        for (FileInfo file : filesToTransfer) {
            this.executorService.submit(() -> {
                TcpConnection currentConnection = null;
                try {
                    semaphore.acquire();
                    if (!this.isRunning()) {
                        this.close();
                        return;
                    }
                    currentConnection = (TcpConnection)connections.poll();
                    if (currentConnection == null) {
                        throw new RuntimeException("[CLIENT] No connection available");
                    }
                    log.debug("[CLIENT-{}] transferring file {}", (Object)currentConnection.getConnectionId(), (Object)file.getRelativePath());
                    this.transferFile(file, args, currentConnection);
                }
                catch (Exception e) {
                    log.error("[CLIENT] Error transferring file 1 {}: {}", (Object)file.getRelativePath(), (Object)e.getMessage());
                }
                finally {
                    if (currentConnection != null) {
                        connections.add(currentConnection);
                    }
                    semaphore.release();
                    completionLatch.countDown();
                }
            });
        }
        try {
            completionLatch.await();
            log.debug("[CLIENT] All file transfers completed 2");
        }
        catch (InterruptedException e) {
            log.error("[CLIENT] File transfer interrupted 2: {}", (Object)e.getMessage());
        }
        System.out.println("[CLIENT] Send all local to remote files");
        connection.sendMessage(new FileSyncMessageAck());
        response = connection.receiveMessage();
        if (response.getMessageType() != MessageType.FILE_LIST_RESPONSE) {
            log.error("[CLIENT] Unexpected response 6: {}", (Object)response.getMessageType());
            return;
        }
        FileListResponseMessage retrieveListResponse = (FileListResponseMessage)response;
        Map<String, FileInfo> mapToTransferInitialRetrieve = retrieveListResponse.getFilesToTransfer().stream().collect(Collectors.toMap(fileInfo -> FileUtils.makeUniformPath(fileInfo.getRelativePath()), fileInfo -> fileInfo));
        ConcurrentHashMap<String, FileInfo> mapToTransferRetrieve = new ConcurrentHashMap<String, FileInfo>(mapToTransferInitialRetrieve);
        CountDownLatch completionLatchRetrieve = new CountDownLatch(mapToTransferRetrieve.size());
        ConcurrentLinkedQueue<TcpConnection> connectionsRetrieve = new ConcurrentLinkedQueue<TcpConnection>();
        Semaphore semaphoreRetrieve = new Semaphore(maxConnections);
        for (int i = 0; i < maxConnections; ++i) {
            TcpConnection subConnection = this.getTcpConnection(connection, args, i, maxPacketSize);
            connectionsRetrieve.add(subConnection);
            StartRestore startRestoreMessage2 = new StartRestore();
            startRestoreMessage2.initialize(subConnection.getConnectionId(), subConnection.getSessionId(), 0);
            subConnection.sendMessage(startRestoreMessage2);
            Message message = subConnection.receiveMessage();
            if (message.getMessageType() == MessageType.START_RESTORE_ACK) continue;
            log.error("[CLIENT] Unexpected message 5: {}", (Object)message.getMessageType());
            throw new IOException("Unexpected message 5: " + message.getMessageType());
        }
        StartRestore startRestoreMessage = new StartRestore();
        startRestoreMessage.initialize(connection.getConnectionId(), connection.getSessionId(), 0);
        connection.sendMessage(startRestoreMessage);
        Message message = connection.receiveMessage();
        if (message.getMessageType() != MessageType.START_RESTORE_ACK) {
            log.error("[CLIENT] Unexpected message 6: {}", (Object)message.getMessageType());
            throw new IOException("Unexpected message 6: " + message.getMessageType());
        }
        while (!mapToTransferRetrieve.isEmpty()) {
            try {
                semaphoreRetrieve.acquire();
            }
            catch (InterruptedException startRestoreMessage2) {
                // empty catch block
            }
            this.executorService.submit(() -> this.performSingleFileRestore(args, connectionsRetrieve, mapToTransferRetrieve, semaphoreRetrieve, completionLatchRetrieve));
        }
        try {
            while (!mapToTransferRetrieve.isEmpty()) {
                Sleeper.sleep(100L);
            }
            completionLatchRetrieve.await();
            log.debug("[CLIENT] All file transfers completed 8");
            int startRestoreMessage2 = this.counter.incrementAndGet();
        }
        catch (InterruptedException e) {
            log.error("[CLIENT] File transfer interrupted 8: {}", (Object)e.getMessage());
        }
        finally {
            int cc = this.counter.get();
            statusAnalyzer.analyze();
            this.executorService.shutdown();
        }
    }
}

