/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.lib.buffer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kendar.sync.lib.buffer.ByteContainerStructure;
import org.kendar.sync.lib.buffer.converters.BackupTypeConverter;
import org.kendar.sync.lib.buffer.converters.BooleanConverter;
import org.kendar.sync.lib.buffer.converters.ByteArrayConverter;
import org.kendar.sync.lib.buffer.converters.ByteContainerConverter;
import org.kendar.sync.lib.buffer.converters.IntConverter;
import org.kendar.sync.lib.buffer.converters.LongConverter;
import org.kendar.sync.lib.buffer.converters.MessageTypeConverter;
import org.kendar.sync.lib.buffer.converters.StringConverter;
import org.kendar.sync.lib.buffer.converters.UUIDConverter;

public class ByteContainer {
    private final List<byte[]> data = new ArrayList<byte[]>();
    private int size = 0;
    private boolean changed = false;
    private HashMap<Class<?>, ByteContainerConverter> converters = new HashMap();
    private int writeCursor = 0;
    private int readCursor = 0;

    public ByteContainer() {
    }

    public ByteContainer(int size) {
        this.size = size;
        this.data.add(new byte[size]);
    }

    public static ByteContainer create() {
        return new ByteContainer().withConverters(new IntConverter(), new StringConverter(), new ByteArrayConverter(), new LongConverter(), new UUIDConverter(), new MessageTypeConverter(), new BackupTypeConverter(), new BooleanConverter());
    }

    public ByteContainer clone() {
        ByteContainer clone = new ByteContainer();
        clone.converters = this.converters;
        return clone;
    }

    public ByteContainer withConverters(ByteContainerConverter ... offeredConverters) {
        for (ByteContainerConverter converter : offeredConverters) {
            this.converters.put(converter.getType(), converter);
        }
        return this;
    }

    private List<ByteContainerStructure> getInternalOffsets(int offset, int length) {
        ArrayList<ByteContainerStructure> result = new ArrayList<ByteContainerStructure>();
        int currentOffset = 0;
        int currentLength = length;
        for (int dataIndex = 0; dataIndex < this.data.size(); ++dataIndex) {
            byte[] bytes = this.data.get(dataIndex);
            if (offset >= currentOffset && offset < currentOffset + bytes.length) {
                int internalIndex = offset - currentOffset;
                ByteContainerStructure di = new ByteContainerStructure(dataIndex, internalIndex);
                if (bytes.length >= internalIndex + currentLength) {
                    di.length = currentLength;
                    result.add(di);
                    return result;
                }
                di.length = bytes.length - internalIndex;
                currentLength -= di.length;
                result.add(di);
            }
            currentOffset += bytes.length;
        }
        if (currentLength > 0) {
            this.data.add(new byte[currentLength]);
            ByteContainerStructure remain = new ByteContainerStructure(this.data.size() - 1, 0);
            remain.length = currentLength;
            result.add(remain);
        }
        return result;
    }

    public int size() {
        return this.size;
    }

    public byte[] read(int offset, int length) {
        if (offset + length > this.size) {
            throw new IndexOutOfBoundsException();
        }
        byte[] data = this.getBytes();
        byte[] result = new byte[length];
        System.arraycopy(data, offset, result, 0, length);
        return result;
    }

    public void write(byte data) {
        this.write(data, this.writeCursor);
        ++this.writeCursor;
    }

    public void clear() {
        this.writeCursor = 0;
        this.readCursor = 0;
        this.changed = false;
        this.size = 0;
        this.data.clear();
    }

    public byte read() {
        byte[] result = this.read(1);
        return result[0];
    }

    public byte[] readToEnd() {
        int len = this.size - this.readCursor;
        return this.read(len);
    }

    public int getRemaining() {
        return this.size - this.readCursor;
    }

    public int getWriteCursor() {
        return this.writeCursor;
    }

    public void resetWriteCursor() {
        this.writeCursor = 0;
    }

    public void resetReadCursor() {
        this.readCursor = 0;
    }

    public int getReadCursor() {
        return this.readCursor;
    }

    public byte[] read(int length) {
        if (this.readCursor + length > this.size) {
            throw new IndexOutOfBoundsException();
        }
        byte[] data = this.getBytes();
        byte[] result = new byte[length];
        System.arraycopy(data, this.readCursor, result, 0, length);
        this.readCursor += length;
        return result;
    }

    public <T> void writeType(T toWrite) {
        ByteContainerConverter converter = this.converters.get(toWrite.getClass());
        if (converter != null) {
            byte[] bytes = converter.toBytes(toWrite);
            this.write(bytes);
            return;
        }
        throw new ClassCastException();
    }

    public <T> void writeType(T toWrite, int offset) {
        ByteContainerConverter converter = this.converters.get(toWrite.getClass());
        if (converter != null) {
            byte[] bytes = converter.toBytes(toWrite);
            this.write(bytes, offset, converter.getSize());
            return;
        }
        throw new ClassCastException();
    }

    public <T> T readType(Class<T> type) {
        ByteContainerConverter converter = this.converters.get(type);
        if (converter != null) {
            int size = converter.getSize(this, -1);
            byte[] bytes = this.read(size);
            return converter.fromBytes(bytes);
        }
        throw new ClassCastException();
    }

    public <T> T readType(Class<T> type, int offset) {
        ByteContainerConverter converter = this.converters.get(type);
        if (converter != null) {
            int size = converter.getSize(this, offset);
            byte[] bytes = this.read(offset, size);
            return converter.fromBytes(bytes);
        }
        throw new ClassCastException();
    }

    public ByteContainer write(byte[] data) {
        this.write(data, this.writeCursor, data.length);
        this.writeCursor += data.length;
        return this;
    }

    public ByteContainer write(byte[] buf, int offset, int length) {
        if (length > buf.length) {
            throw new IllegalArgumentException("Length exceeds buffer size.");
        }
        if (offset > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (offset == this.size || this.size == 0) {
            this.data.add(buf);
            this.size += length;
            this.changed = true;
            return this;
        }
        int remainingLength = length;
        int sourceOffset = 0;
        List<ByteContainerStructure> internalOffset = this.getInternalOffsets(offset, length);
        for (ByteContainerStructure io : internalOffset) {
            byte[] dataItem = this.data.get(io.dataIndex);
            System.arraycopy(buf, sourceOffset, dataItem, io.internalIndex, io.length);
            sourceOffset += io.length;
            if ((remainingLength -= io.length) != 0) continue;
            break;
        }
        this.size = this.data.stream().mapToInt(bytes -> ((byte[])bytes).length).sum();
        return this;
    }

    public void write(byte value, int offset) {
        this.write(new byte[]{value}, offset, 1);
    }

    public ByteContainer splice(int offset, int length) {
        byte[] data = this.getBytes();
        if (this.size < offset + length) {
            throw new IndexOutOfBoundsException();
        }
        byte[] resultData = new byte[length];
        System.arraycopy(data, offset, resultData, 0, length);
        ByteContainer result = this.clone();
        result.write(resultData);
        if (offset == 0) {
            byte[] trailing = new byte[this.size - length];
            System.arraycopy(data, length, trailing, 0, trailing.length);
            this.clear();
            this.write(trailing);
        } else {
            int lastLen = data.length - offset - length;
            byte[] prefix = new byte[offset + lastLen];
            System.arraycopy(data, 0, prefix, 0, offset);
            System.arraycopy(data, length + offset, prefix, offset, lastLen);
            this.clear();
            this.write(prefix);
        }
        return result;
    }

    public byte[] getBytes() {
        if (this.changed && this.data.size() > 1) {
            byte[] result = new byte[this.size];
            int offset = 0;
            for (byte[] b : this.data) {
                System.arraycopy(b, 0, result, offset, b.length);
                offset += b.length;
            }
            this.data.clear();
            this.data.add(result);
        }
        if (this.data.size() == 1) {
            return this.data.get(0);
        }
        return new byte[0];
    }
}

