/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.lib.buffer.converters;

import org.kendar.sync.lib.buffer.converters.ByteContainerConverter;
import org.kendar.sync.lib.protocol.BackupType;

public class BackupTypeConverter
extends ByteContainerConverter<BackupType> {
    @Override
    public Class<BackupType> getType() {
        return BackupType.class;
    }

    @Override
    public BackupType fromBytes(byte[] bytes) {
        String str = new String(bytes);
        if (str.equalsIgnoreCase("PR")) {
            return BackupType.PRESERVE;
        }
        if (str.equalsIgnoreCase("MI")) {
            return BackupType.MIRROR;
        }
        if (str.equalsIgnoreCase("NO")) {
            return BackupType.NONE;
        }
        if (str.equalsIgnoreCase("DA")) {
            return BackupType.DATE_SEPARATED;
        }
        if (str.equalsIgnoreCase("TW")) {
            return BackupType.TWO_WAY_SYNC;
        }
        return BackupType.valueOf(new String(bytes));
    }

    @Override
    public byte[] toBytes(BackupType value) {
        if (value == BackupType.PRESERVE) {
            return new byte[]{80, 82};
        }
        if (value == BackupType.MIRROR) {
            return new byte[]{77, 73};
        }
        if (value == BackupType.NONE) {
            return new byte[]{78, 79};
        }
        if (value == BackupType.DATE_SEPARATED) {
            return new byte[]{68, 65};
        }
        if (value == BackupType.TWO_WAY_SYNC) {
            return new byte[]{84, 87};
        }
        return new byte[]{(byte)value.name().charAt(0), (byte)value.name().charAt(1)};
    }

    @Override
    public int getSize() {
        return 2;
    }
}

