/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.lib.network;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.UUID;
import org.kendar.sync.client.RetryException;
import org.kendar.sync.lib.protocol.ErrorMessage;
import org.kendar.sync.lib.protocol.Message;
import org.kendar.sync.lib.protocol.MessageType;
import org.kendar.sync.lib.protocol.Packet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpConnection
implements AutoCloseable {
    private final Socket socket;
    private final int packetId;
    private int maxPacketSize;
    private final OutputStream outputStream;
    private InputStream inputStream;
    private UUID sessionId;
    private int connectionId;
    private Runnable sessionTouch;
    private boolean server = false;
    private Object lock = new Object();
    private static final Logger log = LoggerFactory.getLogger(TcpConnection.class);

    public void setServer(boolean server) {
        this.server = server;
    }

    public boolean isServer() {
        return this.server;
    }

    public TcpConnection(Socket socket, UUID sessionId, int connectionId, int maxPacketSize) throws IOException {
        this.socket = socket;
        this.inputStream = socket.getInputStream();
        this.outputStream = socket.getOutputStream();
        this.sessionId = sessionId;
        this.connectionId = connectionId;
        this.packetId = 0;
        this.maxPacketSize = maxPacketSize;
    }

    public void sendError(String code, String error) {
        this.sendError(code, error, "");
    }

    public void sendError(String code, String error, String details) {
        ErrorMessage message = new ErrorMessage(code, error, details);
        try {
            this.sendMessage(message);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof TcpConnection)) {
            return false;
        }
        TcpConnection that = (TcpConnection)o;
        return Objects.equals(this.socket, that.socket);
    }

    public int hashCode() {
        return Objects.hashCode(this.socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(Message message) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            byte[] messageData = message.serialize();
            Packet packet = new Packet(this.connectionId, this.sessionId, this.packetId, message.getMessageType().getCode(), messageData);
            byte[] packetData = packet.serialize();
            this.outputStream.write(packetData);
            this.outputStream.flush();
            if (this.sessionTouch != null) {
                this.sessionTouch.run();
            }
        }
    }

    public Message receiveMessage() throws IOException {
        try {
            Message result;
            do {
                if (this.sessionTouch != null) {
                    this.sessionTouch.run();
                }
                byte[] lengthBytes = new byte[4];
                this.inputStream = this.socket.getInputStream();
                int bytesRead = this.inputStream.read(lengthBytes);
                if (bytesRead != 4) {
                    if (bytesRead == -1) {
                        return null;
                    }
                    throw new IOException("Failed to read packet length");
                }
                int packetLength = ByteBuffer.wrap(lengthBytes).getInt();
                if (packetLength <= 0 || packetLength > this.maxPacketSize + 1024) {
                    log.error("Packet length out of range was {} max is {}", (Object)packetLength, (Object)this.maxPacketSize);
                    throw new IOException("Invalid packet length: " + packetLength);
                }
                byte[] packetData = new byte[packetLength];
                System.arraycopy(lengthBytes, 0, packetData, 0, 4);
                int offset = 4;
                for (int remaining = packetLength - 4; remaining > 0; remaining -= bytesRead) {
                    bytesRead = this.inputStream.read(packetData, offset, remaining);
                    if (bytesRead == -1) {
                        throw new IOException("End of stream reached");
                    }
                    offset += bytesRead;
                }
                Packet packet = Packet.deserialize(packetData);
                result = Message.deserialize(packet.getDecompressedContent());
                result.initialize(packet.getConnectionId(), packet.getSessionId(), packet.getPacketId());
            } while (result.getMessageType() == MessageType.KEEP_ALIVE);
            if (result.getMessageType() == MessageType.ERROR) {
                ErrorMessage errorMessage = (ErrorMessage)result;
                log.error("[{}-{}] Error received: {}-{}-{}", new Object[]{this.server ? "SERVER" : "CLIENT", this.getConnectionId(), errorMessage.getErrorCode(), errorMessage.getErrorMessage(), errorMessage.getDetails()});
                if (errorMessage.getErrorCode().equals("ERR_BUSY")) {
                    throw new RetryException(errorMessage.getErrorCode(), errorMessage.getErrorMessage(), errorMessage.getDetails());
                }
                throw new IOException(errorMessage.getErrorCode() + "-" + errorMessage.getErrorMessage() + "-" + errorMessage.getDetails());
            }
            return result;
        }
        catch (SocketException se) {
            log.error("[{}-{}] Socket exception: {}", new Object[]{this.server ? "SERVER" : "CLIENT", this.getConnectionId(), se.getMessage()});
            throw new SocketException(se.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        log.debug("[{}-{}] Closing socket", (Object)(this.server ? "SERVER" : "CLIENT"), (Object)this.getConnectionId());
        this.inputStream.close();
        this.outputStream.close();
        this.socket.close();
    }

    public UUID getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(UUID sessionId) {
        this.sessionId = sessionId;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(int connectionId) {
        this.connectionId = connectionId;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public boolean isClosed() {
        return !this.socket.isConnected() || this.socket.isClosed() || !this.socket.isBound();
    }

    public void setSession(Runnable sessionTouch) {
        this.sessionTouch = sessionTouch;
    }

    public void setMaxPacketSize(int maxPacketSize) {
        this.maxPacketSize = maxPacketSize;
    }
}

