/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.lib.protocol;

import java.util.ArrayList;
import java.util.List;
import org.kendar.sync.lib.buffer.ByteContainer;
import org.kendar.sync.lib.protocol.BackupType;
import org.kendar.sync.lib.protocol.Message;
import org.kendar.sync.lib.protocol.MessageType;

public class ConnectResponseMessage
extends Message {
    private boolean accepted;
    private String errorMessage = "";
    private int maxPacketSize;
    private int maxConnections;
    private BackupType backupType;
    private boolean ignoreSystemFiles = true;
    private boolean ignoreHiddenFiles = true;
    private List<String> ignoredPatterns = new ArrayList<String>();

    public boolean isIgnoreSystemFiles() {
        return this.ignoreSystemFiles;
    }

    public void setIgnoreSystemFiles(boolean ignoreSystemFiles) {
        this.ignoreSystemFiles = ignoreSystemFiles;
    }

    public boolean isIgnoreHiddenFiles() {
        return this.ignoreHiddenFiles;
    }

    public void setIgnoreHiddenFiles(boolean ignoreHiddenFiles) {
        this.ignoreHiddenFiles = ignoreHiddenFiles;
    }

    public List<String> getIgnoredPatterns() {
        return this.ignoredPatterns;
    }

    public void setIgnoredPatterns(List<String> ignoredPatterns) {
        this.ignoredPatterns = ignoredPatterns;
    }

    public ConnectResponseMessage() {
    }

    public ConnectResponseMessage(boolean accepted, String errorMessage, int maxPacketSize, int maxConnections, BackupType backupType, boolean ignoreSystemFiles, boolean ignoreHiddenFiles, List<String> ignoredPatterns) {
        this.accepted = accepted;
        this.errorMessage = errorMessage;
        this.maxPacketSize = maxPacketSize;
        this.maxConnections = maxConnections;
        this.backupType = backupType;
        this.ignoreSystemFiles = ignoreSystemFiles;
        this.ignoreHiddenFiles = ignoreHiddenFiles;
        this.ignoredPatterns = ignoredPatterns;
    }

    public static ConnectResponseMessage accepted(int maxPacketSize, int maxConnections, boolean ignoreSystemFiles, boolean ignoreHiddenFiles, List<String> ignoredPatterns) {
        return new ConnectResponseMessage(true, null, maxPacketSize, maxConnections, BackupType.NONE, ignoreSystemFiles, ignoreHiddenFiles, ignoredPatterns);
    }

    public static ConnectResponseMessage rejected(String errorMessage) {
        return new ConnectResponseMessage(false, errorMessage, 0, 0, BackupType.NONE, true, true, new ArrayList<String>());
    }

    @Override
    protected Message deserialize(ByteContainer buffer) {
        this.accepted = buffer.readType(Boolean.class);
        this.errorMessage = buffer.readType(String.class);
        this.maxPacketSize = buffer.readType(Integer.class);
        this.maxConnections = buffer.readType(Integer.class);
        this.backupType = buffer.readType(BackupType.class);
        this.ignoreHiddenFiles = buffer.readType(Boolean.class);
        this.ignoreSystemFiles = buffer.readType(Boolean.class);
        String patterns = buffer.readType(String.class);
        if (patterns != null && !patterns.isEmpty()) {
            this.ignoredPatterns = List.of(patterns.split(","));
        }
        return this;
    }

    @Override
    public MessageType getMessageType() {
        return MessageType.CONNECT_RESPONSE;
    }

    @Override
    protected void serialize(ByteContainer buffer) {
        buffer.writeType(this.accepted);
        if (this.errorMessage == null) {
            buffer.writeType("");
        } else {
            buffer.writeType(this.errorMessage);
        }
        buffer.writeType(this.maxPacketSize);
        buffer.writeType(this.maxConnections);
        buffer.writeType(this.backupType);
        buffer.writeType(this.ignoreHiddenFiles);
        buffer.writeType(this.ignoreSystemFiles);
        if (this.ignoredPatterns != null && !this.ignoredPatterns.isEmpty()) {
            buffer.writeType(String.join((CharSequence)",", this.ignoredPatterns));
        } else {
            buffer.writeType("");
        }
    }

    public BackupType getBackupType() {
        return this.backupType;
    }

    public void setBackupType(BackupType backupType) {
        this.backupType = backupType;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public void setAccepted(boolean accepted) {
        this.accepted = accepted;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public void setMaxPacketSize(int maxPacketSize) {
        this.maxPacketSize = maxPacketSize;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }
}

