/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.lib.protocol;

import org.kendar.sync.lib.buffer.ByteContainer;
import org.kendar.sync.lib.protocol.Message;
import org.kendar.sync.lib.protocol.MessageType;

public class FileEndAckMessage
extends Message {
    private String relativePath;
    private boolean success;
    private String errorMessage;

    public FileEndAckMessage() {
    }

    public FileEndAckMessage(String relativePath, boolean success, String errorMessage) {
        this.relativePath = relativePath;
        this.success = success;
        this.errorMessage = errorMessage;
    }

    public static FileEndAckMessage success(String relativePath) {
        return new FileEndAckMessage(relativePath, true, null);
    }

    public static FileEndAckMessage failure(String relativePath, String errorMessage) {
        return new FileEndAckMessage(relativePath, false, errorMessage);
    }

    @Override
    public MessageType getMessageType() {
        return MessageType.FILE_END_ACK;
    }

    @Override
    protected Message deserialize(ByteContainer buffer) {
        this.relativePath = buffer.readType(String.class);
        this.success = buffer.readType(Boolean.class);
        this.errorMessage = buffer.readType(String.class);
        return this;
    }

    @Override
    protected void serialize(ByteContainer buffer) {
        buffer.writeType(this.relativePath);
        buffer.writeType(this.success);
        if (this.errorMessage != null) {
            buffer.writeType(this.errorMessage);
        } else {
            buffer.writeType("");
        }
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

