/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.lib.protocol;

import org.kendar.sync.lib.buffer.ByteContainer;
import org.kendar.sync.lib.model.FileInfo;
import org.kendar.sync.lib.protocol.Message;
import org.kendar.sync.lib.protocol.MessageType;

public class FileEndMessage
extends Message {
    private String relativePath;
    private FileInfo fileInfo;

    public FileEndMessage() {
    }

    public FileEndMessage(String relativePath, FileInfo fileInfo) {
        this.relativePath = relativePath;
        this.fileInfo = fileInfo;
    }

    public FileEndMessage(String relativePath) {
        this.relativePath = relativePath;
        this.fileInfo = null;
    }

    @Override
    public MessageType getMessageType() {
        return MessageType.FILE_END;
    }

    @Override
    protected Message deserialize(ByteContainer buffer) {
        this.relativePath = buffer.readType(String.class);
        String ff = buffer.readType(String.class);
        if (!ff.isEmpty()) {
            this.fileInfo = FileInfo.fromLine(ff);
        }
        return this;
    }

    @Override
    protected void serialize(ByteContainer buffer) {
        buffer.writeType(this.relativePath);
        if (this.fileInfo != null) {
            buffer.writeType(this.fileInfo.toLine());
        } else {
            buffer.writeType("");
        }
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    public void setFileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
    }
}

