/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.lib.protocol;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.kendar.sync.lib.buffer.ByteContainer;
import org.kendar.sync.lib.model.FileInfo;
import org.kendar.sync.lib.protocol.Message;
import org.kendar.sync.lib.protocol.MessageType;

public class FileListMessage
extends Message {
    private List<FileInfo> files;
    private boolean isBackup;
    private int partNumber;
    private int totalParts;

    public FileListMessage() {
        this.files = new ArrayList<FileInfo>();
    }

    public FileListMessage(List<FileInfo> files, boolean isBackup, int partNumber, int totalParts) {
        this.files = files;
        this.isBackup = isBackup;
        this.partNumber = partNumber;
        this.totalParts = totalParts;
    }

    @Override
    public MessageType getMessageType() {
        return MessageType.FILE_LIST;
    }

    @Override
    protected Message deserialize(ByteContainer buffer) {
        String[] filesLines = buffer.readType(String.class).split("\n");
        this.files = new ArrayList<FileInfo>();
        for (String fileLine : filesLines) {
            if (fileLine.isEmpty()) continue;
            this.files.add(FileInfo.fromLine(fileLine));
        }
        this.isBackup = buffer.readType(Boolean.class);
        this.partNumber = buffer.readType(Integer.class);
        this.totalParts = buffer.readType(Integer.class);
        return this;
    }

    @Override
    protected void serialize(ByteContainer buffer) {
        List filesLines = this.files.stream().map(FileInfo::toLine).collect(Collectors.toList());
        buffer.writeType(String.join((CharSequence)"\n", filesLines));
        buffer.writeType(this.isBackup);
        buffer.writeType(this.partNumber);
        buffer.writeType(this.totalParts);
    }

    public List<FileInfo> getFiles() {
        return this.files;
    }

    public void setFiles(List<FileInfo> files) {
        this.files = files;
    }

    public boolean isBackup() {
        return this.isBackup;
    }

    public void setBackup(boolean backup) {
        this.isBackup = backup;
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(int partNumber) {
        this.partNumber = partNumber;
    }

    public int getTotalParts() {
        return this.totalParts;
    }

    public void setTotalParts(int totalParts) {
        this.totalParts = totalParts;
    }

    public void addFile(FileInfo file) {
        this.files.add(file);
    }
}

