/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.lib.protocol;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.kendar.sync.lib.buffer.ByteContainer;
import org.kendar.sync.lib.model.FileInfo;
import org.kendar.sync.lib.protocol.Message;
import org.kendar.sync.lib.protocol.MessageType;

public class FileListResponseMessage
extends Message {
    private List<FileInfo> filesToTransfer;
    private List<String> filesToDelete;
    private boolean isBackup;
    private int partNumber;
    private int totalParts;

    public FileListResponseMessage() {
        this.filesToTransfer = new ArrayList<FileInfo>();
        this.filesToDelete = new ArrayList<String>();
    }

    public FileListResponseMessage(List<FileInfo> filesToTransfer, List<String> filesToDelete, boolean isBackup, int partNumber, int totalParts) {
        this.filesToTransfer = filesToTransfer;
        this.filesToDelete = filesToDelete;
        this.isBackup = isBackup;
        this.partNumber = partNumber;
        this.totalParts = totalParts;
    }

    @Override
    public MessageType getMessageType() {
        return MessageType.FILE_LIST_RESPONSE;
    }

    @Override
    protected Message deserialize(ByteContainer buffer) {
        String[] filesLines = buffer.readType(String.class).split("\n");
        this.filesToTransfer = new ArrayList<FileInfo>();
        for (String fileLine : filesLines) {
            if (fileLine.isEmpty()) continue;
            this.filesToTransfer.add(FileInfo.fromLine(fileLine));
        }
        String filesToDeleteLine = buffer.readType(String.class);
        this.filesToDelete = new ArrayList<String>();
        for (String fileToDeleteLine : filesToDeleteLine.split("\n")) {
            if (fileToDeleteLine.isEmpty()) continue;
            this.filesToDelete.add(fileToDeleteLine);
        }
        this.isBackup = buffer.readType(Boolean.class);
        this.partNumber = buffer.readType(Integer.class);
        this.totalParts = buffer.readType(Integer.class);
        return this;
    }

    @Override
    protected void serialize(ByteContainer buffer) {
        List filesLines = this.filesToTransfer.stream().map(FileInfo::toLine).collect(Collectors.toList());
        buffer.writeType(String.join((CharSequence)"\n", filesLines));
        buffer.writeType(String.join((CharSequence)"\n", this.filesToDelete));
        buffer.writeType(this.isBackup);
        buffer.writeType(this.partNumber);
        buffer.writeType(this.totalParts);
    }

    public List<FileInfo> getFilesToTransfer() {
        return this.filesToTransfer;
    }

    public void setFilesToTransfer(List<FileInfo> filesToTransfer) {
        this.filesToTransfer = filesToTransfer;
    }

    public List<String> getFilesToDelete() {
        return this.filesToDelete;
    }

    public void setFilesToDelete(List<String> filesToDelete) {
        this.filesToDelete = filesToDelete;
    }

    public boolean isBackup() {
        return this.isBackup;
    }

    public void setBackup(boolean backup) {
        this.isBackup = backup;
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(int partNumber) {
        this.partNumber = partNumber;
    }

    public int getTotalParts() {
        return this.totalParts;
    }

    public void setTotalParts(int totalParts) {
        this.totalParts = totalParts;
    }

    public void addFileToTransfer(FileInfo file) {
        this.filesToTransfer.add(file);
    }

    public void addFileToDelete(String relativePath) {
        this.filesToDelete.add(relativePath);
    }
}

