/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.lib.protocol;

import org.kendar.sync.lib.buffer.ByteContainer;
import org.kendar.sync.lib.protocol.Message;
import org.kendar.sync.lib.protocol.MessageType;

public class FileSyncMessageAck
extends Message {
    private boolean success;
    private String errorMessage;

    public FileSyncMessageAck() {
    }

    public FileSyncMessageAck(boolean success, String errorMessage) {
        this.success = success;
        this.errorMessage = errorMessage;
    }

    public static FileSyncMessageAck success() {
        return new FileSyncMessageAck(true, null);
    }

    public static FileSyncMessageAck failure(String errorMessage) {
        return new FileSyncMessageAck(false, errorMessage);
    }

    @Override
    public MessageType getMessageType() {
        return MessageType.FILE_SYNC_ACK;
    }

    @Override
    protected Message deserialize(ByteContainer buffer) {
        this.success = buffer.readType(Boolean.class);
        this.errorMessage = buffer.readType(String.class);
        return this;
    }

    @Override
    protected void serialize(ByteContainer buffer) {
        buffer.writeType(this.success);
        if (this.errorMessage != null) {
            buffer.writeType(this.errorMessage);
        } else {
            buffer.writeType("");
        }
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

