/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.lib.protocol;

import java.util.UUID;
import org.kendar.sync.lib.buffer.ByteContainer;
import org.kendar.sync.lib.protocol.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Message {
    private static final Logger log = LoggerFactory.getLogger(Message.class);
    private int connectionId;
    private UUID sessionId;
    private int packetId;

    public static <T extends Message> T deserialize(byte[] data, Class<T> clazz) {
        ByteContainer buffer = ByteContainer.create();
        buffer.write(data);
        buffer.resetReadCursor();
        buffer.resetWriteCursor();
        MessageType type = buffer.readType(MessageType.class);
        try {
            Message instance = type.createInstance();
            return (T)instance.deserialize(buffer);
        }
        catch (Exception e) {
            log.error("Error 1 deserializing message of type: {}", (Object)type);
            throw new RuntimeException(e);
        }
    }

    public static Message deserialize(byte[] data) {
        ByteContainer buffer = ByteContainer.create();
        buffer.write(data);
        buffer.resetReadCursor();
        buffer.resetWriteCursor();
        MessageType type = buffer.readType(MessageType.class);
        try {
            Message instance = type.createInstance();
            return instance.deserialize(buffer);
        }
        catch (Exception e) {
            log.error("Error 2 deserializing message of type: {}", (Object)type);
            throw new RuntimeException(e);
        }
    }

    protected abstract Message deserialize(ByteContainer var1);

    public int getConnectionId() {
        return this.connectionId;
    }

    public UUID getSessionId() {
        return this.sessionId;
    }

    public int getPacketId() {
        return this.packetId;
    }

    public abstract MessageType getMessageType();

    public byte[] serialize() {
        try {
            ByteContainer buffer = ByteContainer.create();
            buffer.writeType(this.getMessageType());
            this.serialize(buffer);
            return buffer.getBytes();
        }
        catch (Exception e) {
            log.error("Error 3 serializing {}", (Object)this.getClass().getSimpleName());
            throw new RuntimeException(e);
        }
    }

    protected abstract void serialize(ByteContainer var1);

    public void initialize(int connectionId, UUID sessionId, int packetId) {
        this.connectionId = connectionId;
        this.sessionId = sessionId;
        this.packetId = packetId;
    }
}

