/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.lib.protocol;

import java.lang.reflect.Constructor;
import java.util.concurrent.ConcurrentHashMap;
import org.kendar.sync.lib.protocol.ConnectMessage;
import org.kendar.sync.lib.protocol.ConnectResponseMessage;
import org.kendar.sync.lib.protocol.ErrorMessage;
import org.kendar.sync.lib.protocol.FileDataAck;
import org.kendar.sync.lib.protocol.FileDataMessage;
import org.kendar.sync.lib.protocol.FileDescriptorAckMessage;
import org.kendar.sync.lib.protocol.FileDescriptorMessage;
import org.kendar.sync.lib.protocol.FileEndAckMessage;
import org.kendar.sync.lib.protocol.FileEndMessage;
import org.kendar.sync.lib.protocol.FileListMessage;
import org.kendar.sync.lib.protocol.FileListResponseMessage;
import org.kendar.sync.lib.protocol.FileSyncMessage;
import org.kendar.sync.lib.protocol.FileSyncMessageAck;
import org.kendar.sync.lib.protocol.KeepAlive;
import org.kendar.sync.lib.protocol.Message;
import org.kendar.sync.lib.protocol.StartRestore;
import org.kendar.sync.lib.protocol.StartRestoreAck;
import org.kendar.sync.lib.protocol.SyncEndAckMessage;
import org.kendar.sync.lib.protocol.SyncEndMessage;

public enum MessageType {
    CONNECT("CN", ConnectMessage.class),
    CONNECT_RESPONSE("CR", ConnectResponseMessage.class),
    FILE_LIST("FL", FileListMessage.class),
    FILE_LIST_RESPONSE("FR", FileListResponseMessage.class),
    FILE_DESCRIPTOR("FD", FileDescriptorMessage.class),
    FILE_DESCRIPTOR_ACK("FA", FileDescriptorAckMessage.class),
    FILE_DATA("FT", FileDataMessage.class),
    FILE_DATA_ACK("FK", FileDataAck.class),
    FILE_END("FE", FileEndMessage.class),
    FILE_END_ACK("EA", FileEndAckMessage.class),
    SYNC_END("SE", SyncEndMessage.class),
    SYNC_END_ACK("SA", SyncEndAckMessage.class),
    ERROR("ER", ErrorMessage.class),
    START_RESTORE("RS", StartRestore.class),
    START_RESTORE_ACK("RK", StartRestoreAck.class),
    KEEP_ALIVE("KA", KeepAlive.class),
    FILE_SYNC("SY", FileSyncMessage.class),
    FILE_SYNC_ACK("SK", FileSyncMessageAck.class);

    private final String code;
    private final Class<?> clazz;
    private static final ConcurrentHashMap<MessageType, Constructor<?>> constructorMap;

    private MessageType(String code, Class<?> clazz) {
        this.clazz = clazz;
        if (code == null || code.length() != 2) {
            throw new IllegalArgumentException("Message type code must be exactly 2 characters");
        }
        this.code = code;
    }

    public static MessageType fromCode(String code) {
        for (MessageType type : MessageType.values()) {
            if (!type.code.equals(code)) continue;
            return type;
        }
        return null;
    }

    public String getCode() {
        return this.code;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Message createInstance() {
        try {
            Constructor constructor = constructorMap.computeIfAbsent(this, type -> {
                try {
                    return type.getClazz().getDeclaredConstructor(new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("No default constructor for " + type.getClazz().getName(), e);
                }
            });
            return (Message)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create instance of " + this.clazz.getName(), e);
        }
    }

    static {
        constructorMap = new ConcurrentHashMap();
    }
}

