/*
 * Decompiled with CFR 0.152.
 */
package org.kendar.sync.lib.protocol;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class Packet {
    private int length;
    private int connectionId;
    private UUID sessionId;
    private int packetId;
    private String messageType;
    private byte[] content;

    public Packet() {
    }

    public Packet(int connectionId, UUID sessionId, int packetId, String messageType, byte[] content) {
        if (messageType == null || messageType.length() != 2) {
            throw new IllegalArgumentException("Message type must be exactly 2 characters");
        }
        this.connectionId = connectionId;
        this.sessionId = sessionId;
        this.packetId = packetId;
        this.messageType = messageType;
        this.content = this.compress(content);
        this.length = 46 + this.content.length;
    }

    public static Packet deserialize(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        Packet packet = new Packet();
        packet.length = buffer.getInt();
        packet.connectionId = buffer.getInt();
        long mostSigBits = buffer.getLong();
        long leastSigBits = buffer.getLong();
        packet.sessionId = new UUID(mostSigBits, leastSigBits);
        packet.packetId = buffer.getInt();
        char c1 = buffer.getChar();
        char c2 = buffer.getChar();
        packet.messageType = c1 + String.valueOf(c2);
        packet.content = new byte[packet.length - 46];
        buffer.get(packet.content);
        return packet;
    }

    public byte[] serialize() {
        ByteBuffer buffer = ByteBuffer.allocate(this.length);
        buffer.putInt(this.length);
        buffer.putInt(this.connectionId);
        buffer.putLong(this.sessionId.getMostSignificantBits());
        buffer.putLong(this.sessionId.getLeastSignificantBits());
        buffer.putInt(this.packetId);
        buffer.putChar(this.messageType.charAt(0));
        buffer.putChar(this.messageType.charAt(1));
        buffer.put(this.content);
        return buffer.array();
    }

    private byte[] compress(byte[] data) {
        Deflater deflater = new Deflater();
        deflater.setInput(data);
        deflater.finish();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);
        byte[] buffer = new byte[1024];
        while (!deflater.finished()) {
            int count = deflater.deflate(buffer);
            outputStream.write(buffer, 0, count);
        }
        try {
            outputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error compressing data", e);
        }
        return outputStream.toByteArray();
    }

    public byte[] getDecompressedContent() {
        Inflater inflater = new Inflater();
        inflater.setInput(this.content);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(this.content.length);
        byte[] buffer = new byte[1024];
        try {
            while (!inflater.finished()) {
                int count = inflater.inflate(buffer);
                outputStream.write(buffer, 0, count);
            }
            outputStream.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Error decompressing data", e);
        }
        return outputStream.toByteArray();
    }

    public int getLength() {
        return this.length;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public UUID getSessionId() {
        return this.sessionId;
    }

    public int getPacketId() {
        return this.packetId;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public byte[] getContent() {
        return this.content;
    }
}

