/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.core.AcceptHeaderByFileSuffixFilter;
import org.jboss.resteasy.core.AcceptParameterHttpPreprocessor;
import org.jboss.resteasy.core.AsynchronousDispatcher;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.core.ThreadLocalResteasyProviderFactory;
import org.jboss.resteasy.plugins.interceptors.RoleBasedSecurityFeature;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.plugins.providers.ServerFormUrlEncodedProvider;
import org.jboss.resteasy.plugins.server.resourcefactory.JndiComponentResourceFactory;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.InternalDispatcher;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.GetRestful;

public class ResteasyDeployment {
    protected boolean widerRequestMatching;
    protected boolean jaxrs_2_0_RequestMatching = false;
    protected boolean useContainerFormParams = false;
    protected boolean deploymentSensitiveFactoryEnabled = false;
    protected boolean asyncJobServiceEnabled = false;
    protected boolean addCharset = true;
    protected int asyncJobServiceMaxJobResults = 100;
    protected long asyncJobServiceMaxWait = 300000L;
    protected int asyncJobServiceThreadPoolSize = 100;
    protected String asyncJobServiceBasePath = "/asynch/jobs";
    protected String applicationClass;
    protected String injectorFactoryClass;
    protected InjectorFactory injectorFactory;
    protected Application application;
    protected boolean registerBuiltin = true;
    protected List<String> scannedResourceClasses = new ArrayList<String>();
    protected List<String> scannedProviderClasses = new ArrayList<String>();
    protected List<String> scannedJndiComponentResources = new ArrayList<String>();
    protected List<String> jndiComponentResources = new ArrayList<String>();
    protected List<String> providerClasses = new ArrayList<String>();
    protected Set<String> disabledProviderClasses = new HashSet<String>();
    protected List<Class> actualProviderClasses = new ArrayList<Class>();
    protected List<Object> providers = new ArrayList<Object>();
    protected boolean securityEnabled = false;
    protected List<String> jndiResources = new ArrayList<String>();
    protected List<String> resourceClasses = new ArrayList<String>();
    protected List<String> unwrappedExceptions = new ArrayList<String>();
    protected List<Class> actualResourceClasses = new ArrayList<Class>();
    protected List<ResourceFactory> resourceFactories = new ArrayList<ResourceFactory>();
    protected List<Object> resources = new ArrayList<Object>();
    protected Map<String, String> mediaTypeMappings = new HashMap<String, String>();
    protected Map<String, String> languageExtensions = new HashMap<String, String>();
    protected List<String> interceptorPrecedences = new ArrayList<String>();
    protected Map<String, String> interceptorBeforePrecedences = new HashMap<String, String>();
    protected Map<String, String> interceptorAfterPrecedences = new HashMap<String, String>();
    protected Map<Class, Object> defaultContextObjects = new HashMap<Class, Object>();
    protected Map<String, String> constructedDefaultContextObjects = new HashMap<String, String>();
    protected Registry registry;
    protected Dispatcher dispatcher;
    protected ResteasyProviderFactory providerFactory;
    protected ThreadLocalResteasyProviderFactory threadLocalProviderFactory;
    protected String paramMapping;
    private Map<String, Object> properties = new TreeMap<String, Object>();
    protected boolean statisticsEnabled;

    public void start() {
        try {
            this.startInternal();
        }
        finally {
            ThreadLocalResteasyProviderFactory.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startInternal() {
        if (this.providerFactory == null) {
            this.providerFactory = new ResteasyProviderFactory();
        }
        this.providerFactory.setRegisterBuiltins(this.registerBuiltin);
        this.providerFactory.getStatisticsController().setEnabled(this.statisticsEnabled);
        if (this.deploymentSensitiveFactoryEnabled) {
            if (!(this.providerFactory instanceof ThreadLocalResteasyProviderFactory)) {
                if (ResteasyProviderFactory.peekInstance() == null || !(ResteasyProviderFactory.peekInstance() instanceof ThreadLocalResteasyProviderFactory)) {
                    this.threadLocalProviderFactory = new ThreadLocalResteasyProviderFactory(this.providerFactory);
                    ResteasyProviderFactory.setInstance(this.threadLocalProviderFactory);
                } else {
                    ThreadLocalResteasyProviderFactory.push(this.providerFactory);
                }
            } else {
                ThreadLocalResteasyProviderFactory.push(this.providerFactory);
            }
        } else {
            ResteasyProviderFactory.setInstance(this.providerFactory);
        }
        if (this.asyncJobServiceEnabled) {
            AsynchronousDispatcher asyncDispatcher;
            if (this.dispatcher == null) {
                asyncDispatcher = new AsynchronousDispatcher(this.providerFactory);
                this.dispatcher = asyncDispatcher;
            } else {
                asyncDispatcher = (AsynchronousDispatcher)this.dispatcher;
            }
            asyncDispatcher.setMaxCacheSize(this.asyncJobServiceMaxJobResults);
            asyncDispatcher.setMaxWaitMilliSeconds(this.asyncJobServiceMaxWait);
            asyncDispatcher.setThreadPoolSize(this.asyncJobServiceThreadPoolSize);
            asyncDispatcher.setBasePath(this.asyncJobServiceBasePath);
            asyncDispatcher.getUnwrappedExceptions().addAll(this.unwrappedExceptions);
            asyncDispatcher.start();
        } else {
            SynchronousDispatcher dis;
            if (this.dispatcher == null) {
                dis = new SynchronousDispatcher(this.providerFactory);
                this.dispatcher = dis;
            } else {
                dis = (SynchronousDispatcher)this.dispatcher;
            }
            dis.getUnwrappedExceptions().addAll(this.unwrappedExceptions);
        }
        this.registry = this.dispatcher.getRegistry();
        if (this.widerRequestMatching) {
            ((ResourceMethodRegistry)this.registry).setWiderMatching(this.widerRequestMatching);
        }
        this.dispatcher.getDefaultContextObjects().putAll(this.defaultContextObjects);
        this.dispatcher.getDefaultContextObjects().put(Configurable.class, this.providerFactory);
        this.dispatcher.getDefaultContextObjects().put(Configuration.class, this.providerFactory);
        this.dispatcher.getDefaultContextObjects().put(Providers.class, this.providerFactory);
        this.dispatcher.getDefaultContextObjects().put(Registry.class, this.registry);
        this.dispatcher.getDefaultContextObjects().put(Dispatcher.class, this.dispatcher);
        this.dispatcher.getDefaultContextObjects().put(InternalDispatcher.class, InternalDispatcher.getInstance());
        this.dispatcher.getDefaultContextObjects().put(ResteasyDeployment.class, this);
        Map<Class<?>, Object> contextDataMap = ResteasyProviderFactory.getContextDataMap();
        contextDataMap.putAll(this.dispatcher.getDefaultContextObjects());
        try {
            if (this.injectorFactory == null && this.injectorFactoryClass != null) {
                try {
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.injectorFactoryClass);
                    this.injectorFactory = (InjectorFactory)clazz.newInstance();
                }
                catch (ClassNotFoundException cnfe) {
                    throw new RuntimeException(Messages.MESSAGES.unableToFindInjectorFactory(), cnfe);
                }
                catch (Exception e) {
                    throw new RuntimeException(Messages.MESSAGES.unableToInstantiateInjectorFactory(), e);
                }
            }
            if (this.injectorFactory != null) {
                this.providerFactory.setInjectorFactory(this.injectorFactory);
            }
            if (this.constructedDefaultContextObjects != null && this.constructedDefaultContextObjects.size() > 0) {
                for (Map.Entry entry : this.constructedDefaultContextObjects.entrySet()) {
                    Class<?> key = null;
                    try {
                        key = Thread.currentThread().getContextClassLoader().loadClass((String)entry.getKey());
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(Messages.MESSAGES.unableToInstantiateContextObject((String)entry.getKey()), e);
                    }
                    Object obj = ResteasyDeployment.createFromInjectorFactory((String)entry.getValue(), this.providerFactory);
                    LogMessages.LOGGER.creatingContextObject((String)entry.getKey(), (String)entry.getValue());
                    this.defaultContextObjects.put(key, obj);
                    this.dispatcher.getDefaultContextObjects().put(key, obj);
                    contextDataMap.put(key, obj);
                }
            }
            if (this.interceptorPrecedences != null) {
                for (String string : this.interceptorPrecedences) {
                    this.providerFactory.appendInterceptorPrecedence(string.trim());
                }
            }
            if (this.interceptorBeforePrecedences != null) {
                for (Map.Entry entry : this.interceptorBeforePrecedences.entrySet()) {
                    this.providerFactory.insertInterceptorPrecedenceBefore(((String)entry.getKey()).trim(), ((String)entry.getValue()).trim());
                }
            }
            if (this.interceptorAfterPrecedences != null) {
                for (Map.Entry entry : this.interceptorAfterPrecedences.entrySet()) {
                    this.providerFactory.insertInterceptorPrecedenceAfter(((String)entry.getKey()).trim(), ((String)entry.getValue()).trim());
                }
            }
            if (this.securityEnabled) {
                this.providerFactory.register((Class)RoleBasedSecurityFeature.class);
            }
            if (this.registerBuiltin) {
                this.providerFactory.setRegisterBuiltins(true);
                RegisterBuiltin.register(this.providerFactory, this.disabledProviderClasses);
                this.providerFactory.registerProviderInstance(new ServerFormUrlEncodedProvider(this.useContainerFormParams), null, null, true);
            } else {
                this.providerFactory.setRegisterBuiltins(false);
            }
            if (this.applicationClass != null) {
                this.application = ResteasyDeployment.createApplication(this.applicationClass, this.dispatcher, this.providerFactory);
            }
            this.registration();
            if (this.paramMapping != null) {
                this.providerFactory.getContainerRequestFilterRegistry().registerSingleton(new AcceptParameterHttpPreprocessor(this.paramMapping));
            }
            AcceptHeaderByFileSuffixFilter suffixNegotiationFilter = null;
            if (this.mediaTypeMappings != null) {
                HashMap<String, MediaType> hashMap = new HashMap<String, MediaType>();
                for (Map.Entry<String, String> ext : this.mediaTypeMappings.entrySet()) {
                    String value = ext.getValue();
                    hashMap.put(ext.getKey().trim(), MediaType.valueOf(value.trim()));
                }
                if (suffixNegotiationFilter == null) {
                    suffixNegotiationFilter = new AcceptHeaderByFileSuffixFilter();
                    this.providerFactory.getContainerRequestFilterRegistry().registerSingleton(suffixNegotiationFilter);
                }
                suffixNegotiationFilter.setMediaTypeMappings(hashMap);
            }
            if (this.languageExtensions != null) {
                if (suffixNegotiationFilter == null) {
                    suffixNegotiationFilter = new AcceptHeaderByFileSuffixFilter();
                    this.providerFactory.getContainerRequestFilterRegistry().registerSingleton(suffixNegotiationFilter);
                }
                suffixNegotiationFilter.setLanguageMappings(this.languageExtensions);
            }
        }
        finally {
            ResteasyProviderFactory.removeContextDataLevel();
        }
    }

    public void merge(ResteasyDeployment other) {
        this.scannedResourceClasses.addAll(other.getScannedResourceClasses());
        this.scannedProviderClasses.addAll(other.getScannedProviderClasses());
        this.scannedJndiComponentResources.addAll(other.getScannedJndiComponentResources());
        this.jndiComponentResources.addAll(other.getJndiComponentResources());
        this.providerClasses.addAll(other.getProviderClasses());
        this.disabledProviderClasses.addAll(other.getDisabledProviderClasses());
        this.actualProviderClasses.addAll(other.getActualProviderClasses());
        this.providers.addAll(other.getProviders());
        this.jndiResources.addAll(other.getJndiResources());
        this.resourceClasses.addAll(other.getResourceClasses());
        this.unwrappedExceptions.addAll(other.getUnwrappedExceptions());
        this.actualResourceClasses.addAll(other.getActualResourceClasses());
        this.resourceFactories.addAll(other.getResourceFactories());
        this.resources.addAll(other.getResources());
        this.mediaTypeMappings.putAll(other.getMediaTypeMappings());
        this.languageExtensions.putAll(other.getLanguageExtensions());
        this.interceptorPrecedences.addAll(other.getInterceptorPrecedences());
        this.interceptorBeforePrecedences.putAll(other.getInterceptorBeforePrecedences());
        this.interceptorAfterPrecedences.putAll(other.getInterceptorAfterPrecedences());
        this.defaultContextObjects.putAll(other.getDefaultContextObjects());
        this.constructedDefaultContextObjects.putAll(other.getConstructedDefaultContextObjects());
    }

    public static Application createApplication(String applicationClass, Dispatcher dispatcher, ResteasyProviderFactory providerFactory) {
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(applicationClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Application app = (Application)providerFactory.createProviderInstance(clazz);
        dispatcher.getDefaultContextObjects().put(Application.class, app);
        ResteasyProviderFactory.pushContext(Application.class, app);
        PropertyInjector propertyInjector = providerFactory.getInjectorFactory().createPropertyInjector(clazz, providerFactory);
        propertyInjector.inject(app);
        return app;
    }

    public static Object createFromInjectorFactory(String classname, ResteasyProviderFactory providerFactory) {
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(classname);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Object obj = providerFactory.injectedInstance(clazz);
        return obj;
    }

    public void registration() {
        Class<?> clazz;
        boolean useScanning = true;
        if (this.application != null) {
            this.dispatcher.getDefaultContextObjects().put(Application.class, this.application);
            ResteasyProviderFactory.getContextDataMap().put(Application.class, this.application);
            if (this.processApplication(this.application)) {
                useScanning = false;
            }
        }
        if (useScanning && this.scannedProviderClasses != null) {
            for (String string : this.scannedProviderClasses) {
                if (this.disabledProviderClasses.contains(string)) continue;
                this.registerProvider(string);
            }
        }
        if (this.providerClasses != null) {
            for (String string : this.providerClasses) {
                if (this.getDisabledProviderClasses().contains(string)) continue;
                this.registerProvider(string);
            }
        }
        if (this.providers != null) {
            for (Object object : this.providers) {
                if (this.disabledProviderClasses.contains(object.getClass().getName())) continue;
                this.providerFactory.registerProviderInstance(object);
            }
        }
        for (Class clazz2 : this.actualProviderClasses) {
            if (this.disabledProviderClasses.contains(clazz2.getName())) continue;
            this.providerFactory.registerProvider(clazz2);
        }
        if (useScanning && this.scannedJndiComponentResources != null) {
            for (String string : this.scannedJndiComponentResources) {
                this.registerJndiComponentResource(string);
            }
        }
        if (this.jndiComponentResources != null) {
            for (String string : this.jndiComponentResources) {
                this.registerJndiComponentResource(string);
            }
        }
        if (this.jndiResources != null) {
            for (String string : this.jndiResources) {
                this.registry.addJndiResource(string.trim());
            }
        }
        if (useScanning && this.scannedResourceClasses != null) {
            for (String string : this.scannedResourceClasses) {
                clazz = null;
                try {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass(string.trim());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                this.registry.addPerRequestResource(clazz);
            }
        }
        if (this.resourceClasses != null) {
            for (String string : this.resourceClasses) {
                clazz = null;
                try {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass(string.trim());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                this.registry.addPerRequestResource(clazz);
            }
        }
        if (this.resources != null) {
            for (Object object : this.resources) {
                this.registry.addSingletonResource(object);
            }
        }
        for (Class clazz3 : this.actualResourceClasses) {
            this.registry.addPerRequestResource(clazz3);
        }
        for (ResourceFactory resourceFactory : this.resourceFactories) {
            this.registry.addResourceFactory(resourceFactory);
        }
        this.registry.checkAmbiguousUri();
    }

    protected void registerJndiComponentResource(String resource) {
        String[] config = resource.trim().split(";");
        if (config.length < 3) {
            throw new RuntimeException(Messages.MESSAGES.jndiComponentResourceNotSetCorrectly());
        }
        String jndiName = config[0];
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(config[1]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(Messages.MESSAGES.couldNotFindClassJndi(config[1]), e);
        }
        boolean cacheRefrence = Boolean.valueOf(config[2].trim());
        JndiComponentResourceFactory factory = new JndiComponentResourceFactory(jndiName, clazz, cacheRefrence);
        this.getResourceFactories().add(factory);
    }

    public void stop() {
        if (this.asyncJobServiceEnabled) {
            ((AsynchronousDispatcher)this.dispatcher).stop();
        }
        ResteasyProviderFactory.clearInstanceIfEqual(this.threadLocalProviderFactory);
        ResteasyProviderFactory.clearInstanceIfEqual(this.providerFactory);
    }

    protected boolean processApplication(Application config) {
        Map<String, Object> properties;
        Set<Object> singletons;
        LogMessages.LOGGER.deployingApplication(Application.class.getName(), config.getClass());
        boolean registered = false;
        Set<Class<?>> classes = config.getClasses();
        if (classes != null) {
            for (Class<?> clazz : classes) {
                if (GetRestful.isRootResource(clazz)) {
                    LogMessages.LOGGER.addingClassResource(clazz.getName(), config.getClass());
                    this.actualResourceClasses.add(clazz);
                    registered = true;
                    continue;
                }
                LogMessages.LOGGER.addingProviderClass(clazz.getName(), config.getClass());
                this.actualProviderClasses.add(clazz);
                registered = true;
            }
        }
        if ((singletons = config.getSingletons()) != null) {
            for (Object e : singletons) {
                if (GetRestful.isRootResource(e.getClass())) {
                    if (this.actualResourceClasses.contains(e.getClass())) {
                        LogMessages.LOGGER.singletonClassAlreadyDeployed("resource", e.getClass().getName());
                        continue;
                    }
                    LogMessages.LOGGER.addingSingletonResource(e.getClass().getName(), config.getClass());
                    this.resources.add(e);
                    registered = true;
                    continue;
                }
                if (this.actualProviderClasses.contains(e.getClass())) {
                    LogMessages.LOGGER.singletonClassAlreadyDeployed("provider", e.getClass().getName());
                    continue;
                }
                LogMessages.LOGGER.addingProviderSingleton(e.getClass().getName(), config.getClass());
                this.providers.add(e);
                registered = true;
            }
        }
        if ((properties = config.getProperties()) != null && !properties.isEmpty()) {
            Feature feature = new Feature(){

                @Override
                public boolean configure(FeatureContext featureContext) {
                    for (Map.Entry property : properties.entrySet()) {
                        featureContext = (FeatureContext)featureContext.property((String)property.getKey(), property.getValue());
                    }
                    return true;
                }
            };
            this.providers.add(0, feature);
        }
        return registered;
    }

    protected void registerProvider(String clazz) {
        Class<?> provider = null;
        try {
            provider = Thread.currentThread().getContextClassLoader().loadClass(clazz.trim());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.providerFactory.registerProvider(provider);
    }

    public boolean isUseContainerFormParams() {
        return this.useContainerFormParams;
    }

    public void setUseContainerFormParams(boolean useContainerFormParams) {
        this.useContainerFormParams = useContainerFormParams;
    }

    public List<String> getJndiComponentResources() {
        return this.jndiComponentResources;
    }

    public void setJndiComponentResources(List<String> jndiComponentResources) {
        this.jndiComponentResources = jndiComponentResources;
    }

    public String getApplicationClass() {
        return this.applicationClass;
    }

    public void setApplicationClass(String applicationClass) {
        this.applicationClass = applicationClass;
    }

    public String getInjectorFactoryClass() {
        return this.injectorFactoryClass;
    }

    public void setInjectorFactoryClass(String injectorFactoryClass) {
        this.injectorFactoryClass = injectorFactoryClass;
    }

    public boolean isDeploymentSensitiveFactoryEnabled() {
        return this.deploymentSensitiveFactoryEnabled;
    }

    public void setDeploymentSensitiveFactoryEnabled(boolean deploymentSensitiveFactoryEnabled) {
        this.deploymentSensitiveFactoryEnabled = deploymentSensitiveFactoryEnabled;
    }

    public boolean isAsyncJobServiceEnabled() {
        return this.asyncJobServiceEnabled;
    }

    public void setAsyncJobServiceEnabled(boolean asyncJobServiceEnabled) {
        this.asyncJobServiceEnabled = asyncJobServiceEnabled;
    }

    public int getAsyncJobServiceMaxJobResults() {
        return this.asyncJobServiceMaxJobResults;
    }

    public void setAsyncJobServiceMaxJobResults(int asyncJobServiceMaxJobResults) {
        this.asyncJobServiceMaxJobResults = asyncJobServiceMaxJobResults;
    }

    public long getAsyncJobServiceMaxWait() {
        return this.asyncJobServiceMaxWait;
    }

    public void setAsyncJobServiceMaxWait(long asyncJobServiceMaxWait) {
        this.asyncJobServiceMaxWait = asyncJobServiceMaxWait;
    }

    public int getAsyncJobServiceThreadPoolSize() {
        return this.asyncJobServiceThreadPoolSize;
    }

    public void setAsyncJobServiceThreadPoolSize(int asyncJobServiceThreadPoolSize) {
        this.asyncJobServiceThreadPoolSize = asyncJobServiceThreadPoolSize;
    }

    public String getAsyncJobServiceBasePath() {
        return this.asyncJobServiceBasePath;
    }

    public void setAsyncJobServiceBasePath(String asyncJobServiceBasePath) {
        this.asyncJobServiceBasePath = asyncJobServiceBasePath;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public boolean isRegisterBuiltin() {
        return this.registerBuiltin;
    }

    public void setRegisterBuiltin(boolean registerBuiltin) {
        this.registerBuiltin = registerBuiltin;
    }

    public List<String> getProviderClasses() {
        return this.providerClasses;
    }

    public void setProviderClasses(List<String> providerClasses) {
        this.providerClasses = providerClasses;
    }

    public Set<String> getDisabledProviderClasses() {
        return this.disabledProviderClasses;
    }

    public void setDisabledProviderClasses(Set<String> disabledProviderClasses) {
        this.disabledProviderClasses = disabledProviderClasses;
    }

    public List<Object> getProviders() {
        return this.providers;
    }

    public void setProviders(List<Object> providers) {
        this.providers = providers;
    }

    public List<Class> getActualProviderClasses() {
        return this.actualProviderClasses;
    }

    public void setActualProviderClasses(List<Class> actualProviderClasses) {
        this.actualProviderClasses = actualProviderClasses;
    }

    public List<Class> getActualResourceClasses() {
        return this.actualResourceClasses;
    }

    public void setActualResourceClasses(List<Class> actualResourceClasses) {
        this.actualResourceClasses = actualResourceClasses;
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    public void setSecurityEnabled(boolean securityEnabled) {
        this.securityEnabled = securityEnabled;
    }

    public List<String> getJndiResources() {
        return this.jndiResources;
    }

    public void setJndiResources(List<String> jndiResources) {
        this.jndiResources = jndiResources;
    }

    public List<String> getResourceClasses() {
        return this.resourceClasses;
    }

    public void setResourceClasses(List<String> resourceClasses) {
        this.resourceClasses = resourceClasses;
    }

    public Map<String, String> getMediaTypeMappings() {
        return this.mediaTypeMappings;
    }

    public void setMediaTypeMappings(Map<String, String> mediaTypeMappings) {
        this.mediaTypeMappings = mediaTypeMappings;
    }

    public List<Object> getResources() {
        return this.resources;
    }

    public void setResources(List<Object> resources) {
        this.resources = resources;
    }

    public Map<String, String> getLanguageExtensions() {
        return this.languageExtensions;
    }

    public void setLanguageExtensions(Map<String, String> languageExtensions) {
        this.languageExtensions = languageExtensions;
    }

    public List<String> getInterceptorPrecedences() {
        return this.interceptorPrecedences;
    }

    public void setInterceptorPrecedences(List<String> interceptorPrecedences) {
        this.interceptorPrecedences = interceptorPrecedences;
    }

    public Map<String, String> getInterceptorBeforePrecedences() {
        return this.interceptorBeforePrecedences;
    }

    public void setInterceptorBeforePrecedences(Map<String, String> interceptorBeforePrecedences) {
        this.interceptorBeforePrecedences = interceptorBeforePrecedences;
    }

    public Map<String, String> getInterceptorAfterPrecedences() {
        return this.interceptorAfterPrecedences;
    }

    public void setInterceptorAfterPrecedences(Map<String, String> interceptorAfterPrecedences) {
        this.interceptorAfterPrecedences = interceptorAfterPrecedences;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public ResteasyProviderFactory getProviderFactory() {
        return this.providerFactory;
    }

    public void setProviderFactory(ResteasyProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
    }

    public void setMediaTypeParamMapping(String paramMapping) {
        this.paramMapping = paramMapping;
    }

    public List<ResourceFactory> getResourceFactories() {
        return this.resourceFactories;
    }

    public void setResourceFactories(List<ResourceFactory> resourceFactories) {
        this.resourceFactories = resourceFactories;
    }

    public List<String> getUnwrappedExceptions() {
        return this.unwrappedExceptions;
    }

    public void setUnwrappedExceptions(List<String> unwrappedExceptions) {
        this.unwrappedExceptions = unwrappedExceptions;
    }

    public Map<String, String> getConstructedDefaultContextObjects() {
        return this.constructedDefaultContextObjects;
    }

    public void setConstructedDefaultContextObjects(Map<String, String> constructedDefaultContextObjects) {
        this.constructedDefaultContextObjects = constructedDefaultContextObjects;
    }

    public Map<Class, Object> getDefaultContextObjects() {
        return this.defaultContextObjects;
    }

    public void setDefaultContextObjects(Map<Class, Object> defaultContextObjects) {
        this.defaultContextObjects = defaultContextObjects;
    }

    public List<String> getScannedResourceClasses() {
        return this.scannedResourceClasses;
    }

    public void setScannedResourceClasses(List<String> scannedResourceClasses) {
        this.scannedResourceClasses = scannedResourceClasses;
    }

    public List<String> getScannedProviderClasses() {
        return this.scannedProviderClasses;
    }

    public void setScannedProviderClasses(List<String> scannedProviderClasses) {
        this.scannedProviderClasses = scannedProviderClasses;
    }

    public List<String> getScannedJndiComponentResources() {
        return this.scannedJndiComponentResources;
    }

    public void setScannedJndiComponentResources(List<String> scannedJndiComponentResources) {
        this.scannedJndiComponentResources = scannedJndiComponentResources;
    }

    public boolean isWiderRequestMatching() {
        return this.widerRequestMatching;
    }

    public void setWiderRequestMatching(boolean widerRequestMatching) {
        this.widerRequestMatching = widerRequestMatching;
    }

    public boolean isJaxrs_2_0_RequestMatching() {
        return this.jaxrs_2_0_RequestMatching;
    }

    public void setJaxrs_2_0_RequestMatching(boolean jaxrs_2_0_RequestMatching) {
        this.jaxrs_2_0_RequestMatching = jaxrs_2_0_RequestMatching;
    }

    public boolean isAddCharset() {
        return this.addCharset;
    }

    public void setAddCharset(boolean addCharset) {
        this.addCharset = addCharset;
    }

    public InjectorFactory getInjectorFactory() {
        return this.injectorFactory;
    }

    public void setInjectorFactory(InjectorFactory injectorFactory) {
        this.injectorFactory = injectorFactory;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }
}

