/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.util.WeightedMediaType;

public class MediaTypeMatcher<T> {
    protected Map<MediaType, T> representations;

    public Map<MediaType, T> getRepresentations() {
        return this.representations;
    }

    public void setRepresentations(Map<MediaType, T> representations) {
        this.representations = representations;
    }

    public T match(List<MediaType> accepts) {
        ArrayList<WeightedMediaType> convertedAccepts = new ArrayList<WeightedMediaType>();
        for (MediaType mediaType : accepts) {
            convertedAccepts.add(WeightedMediaType.parse(mediaType));
        }
        IdentityHashMap<WeightedMediaType, T> consumesMap = new IdentityHashMap<WeightedMediaType, T>();
        block1: for (Map.Entry<MediaType, T> entry : this.representations.entrySet()) {
            for (WeightedMediaType accept : convertedAccepts) {
                if (!entry.getKey().isCompatible(accept)) continue;
                consumesMap.put(accept, entry.getValue());
                continue block1;
            }
        }
        if (consumesMap.size() == 0) {
            return null;
        }
        if (consumesMap.size() == 1) {
            return (T)consumesMap.values().iterator().next();
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(consumesMap.keySet());
        Collections.sort(arrayList);
        return (T)consumesMap.get(arrayList.get(0));
    }
}

