/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.authorization.util;

import java.util.Arrays;
import java.util.List;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.authorization.util.JsonUtils;
import org.keycloak.adapters.authorization.util.PlaceHolderResolver;
import org.keycloak.adapters.authorization.util.PlaceHolders;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.util.JsonSerialization;

public class KeycloakSecurityContextPlaceHolderResolver
implements PlaceHolderResolver {
    public static final String NAME = "keycloak";

    @Override
    public List<String> resolve(String placeHolder, HttpFacade httpFacade) {
        Object jsonNode;
        String source = placeHolder.substring(placeHolder.indexOf(46) + 1);
        OIDCHttpFacade oidcHttpFacade = (OIDCHttpFacade)OIDCHttpFacade.class.cast(httpFacade);
        KeycloakSecurityContext securityContext = oidcHttpFacade.getSecurityContext();
        if (securityContext == null) {
            return null;
        }
        if (source.endsWith("access_token")) {
            return Arrays.asList(securityContext.getTokenString());
        }
        if (source.endsWith("id_token")) {
            return Arrays.asList(securityContext.getIdTokenString());
        }
        if (source.startsWith("access_token[")) {
            jsonNode = JsonSerialization.mapper.valueToTree(securityContext.getToken());
        } else if (source.startsWith("id_token[")) {
            jsonNode = JsonSerialization.mapper.valueToTree(securityContext.getIdToken());
        } else {
            throw new RuntimeException("Invalid placeholder [" + placeHolder + "]");
        }
        return JsonUtils.getValues(jsonNode, PlaceHolders.getParameter(source, "Invalid placeholder [" + placeHolder + "]"));
    }
}

