/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.util.CaseInsensitiveMap;
import org.jboss.resteasy.util.DateUtil;
import org.jboss.resteasy.util.HeaderHelper;
import org.jboss.resteasy.util.MediaTypeHelper;
import org.jboss.resteasy.util.WeightedLanguage;

public class ClientRequestHeaders {
    protected CaseInsensitiveMap<Object> headers = new CaseInsensitiveMap();
    protected ClientConfiguration configuration;

    public ClientRequestHeaders(ClientConfiguration configuration) {
        this.configuration = configuration;
    }

    public CaseInsensitiveMap<Object> getHeaders() {
        return this.headers;
    }

    public void setHeaders(MultivaluedMap<String, Object> newHeaders) {
        this.headers.clear();
        if (newHeaders == null) {
            return;
        }
        this.headers.putAll(newHeaders);
    }

    public void setLanguage(Locale language) {
        if (language == null) {
            this.headers.remove("Content-Language");
            return;
        }
        this.headers.putSingle("Content-Language", language);
    }

    public void setLanguage(String language) {
        this.setLanguage(new Locale(language));
    }

    public void setMediaType(MediaType mediaType) {
        if (mediaType == null) {
            this.headers.remove("Content-Type");
            return;
        }
        this.headers.putSingle("Content-Type", mediaType);
    }

    public void acceptLanguage(Locale ... locales) {
        String accept = (String)this.headers.getFirst("Accept-Language");
        StringBuilder builder = this.buildAcceptString(accept, locales);
        this.headers.putSingle("Accept-Language", builder.toString());
    }

    public void acceptLanguage(String ... locales) {
        String accept = (String)this.headers.getFirst("Accept-Language");
        StringBuilder builder = this.buildAcceptString(accept, locales);
        this.headers.putSingle("Accept-Language", builder.toString());
    }

    private StringBuilder buildAcceptString(String accept, Object[] items) {
        StringBuilder builder = new StringBuilder();
        if (accept != null) {
            builder.append(accept).append(", ");
        }
        boolean isFirst = true;
        for (Object l : items) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(", ");
            }
            builder.append(this.configuration.toHeaderString(l));
        }
        return builder;
    }

    public void acceptEncoding(String ... encodings) {
        String accept = (String)this.headers.getFirst("Accept-Encoding");
        StringBuilder builder = this.buildAcceptString(accept, encodings);
        this.headers.putSingle("Accept-Encoding", builder.toString());
    }

    public void accept(String ... types) {
        String accept = (String)this.headers.getFirst("Accept");
        StringBuilder builder = this.buildAcceptString(accept, types);
        this.headers.putSingle("Accept", builder.toString());
    }

    public void accept(MediaType ... types) {
        String accept = (String)this.headers.getFirst("Accept");
        StringBuilder builder = this.buildAcceptString(accept, types);
        this.headers.putSingle("Accept", builder.toString());
    }

    public void cookie(Cookie cookie) {
        if (!Cookie.class.equals(cookie.getClass())) {
            cookie = new Cookie(cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getVersion());
        }
        this.headers.add("Cookie", cookie);
    }

    public void allow(String ... methods) {
        HeaderHelper.setAllow(this.headers, methods);
    }

    public void allow(Set<String> methods) {
        HeaderHelper.setAllow(this.headers, methods);
    }

    public void cacheControl(CacheControl cacheControl) {
        this.headers.putSingle("Cache-Control", cacheControl);
    }

    public void header(String name, Object value) {
        if (value == null) {
            this.headers.remove(name);
            return;
        }
        if (name.equalsIgnoreCase("Accept")) {
            this.accept(this.configuration.toHeaderString(value));
        } else if (name.equalsIgnoreCase("Accept-Encoding")) {
            this.acceptEncoding(this.configuration.toHeaderString(value));
        } else if (name.equalsIgnoreCase("Accept-Language")) {
            this.acceptLanguage(this.configuration.toHeaderString(value));
        } else {
            this.headers.add(name, value);
        }
    }

    public Date getDate() {
        Object d = this.headers.getFirst("Date");
        if (d == null) {
            return null;
        }
        if (d instanceof Date) {
            return (Date)d;
        }
        return DateUtil.parseDate(d.toString());
    }

    public String getHeader(String name) {
        Object vals = this.headers.get(name);
        if (vals == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        Iterator iterator = vals.iterator();
        while (iterator.hasNext()) {
            Object val = iterator.next();
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            builder.append(this.configuration.toHeaderString(val));
        }
        return builder.toString();
    }

    public MultivaluedMap<String, String> asMap() {
        CaseInsensitiveMap<String> map = new CaseInsensitiveMap<String>();
        for (Map.Entry entry : this.headers.entrySet()) {
            for (Object obj : entry.getValue()) {
                map.add(entry.getKey(), this.configuration.toHeaderString(obj));
            }
        }
        return map;
    }

    public Locale getLanguage() {
        Object obj = this.headers.getFirst("Content-Language");
        if (obj == null) {
            return null;
        }
        if (obj instanceof Locale) {
            return (Locale)obj;
        }
        return new Locale(obj.toString());
    }

    public int getLength() {
        return -1;
    }

    public MediaType getMediaType() {
        Object obj = this.headers.getFirst("Content-Type");
        if (obj == null) {
            return null;
        }
        if (obj instanceof MediaType) {
            return (MediaType)obj;
        }
        return MediaType.valueOf(this.configuration.toHeaderString(obj));
    }

    public List<MediaType> getAcceptableMediaTypes() {
        ArrayList<MediaType> list = new ArrayList<MediaType>();
        Object accepts = this.headers.get("Accept");
        if (accepts == null) {
            return list;
        }
        Iterator iterator = accepts.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj instanceof MediaType) {
                list.add((MediaType)obj);
                continue;
            }
            String accept = null;
            accept = obj instanceof String ? (String)obj : this.configuration.toHeaderString(obj);
            StringTokenizer tokenizer = new StringTokenizer(accept, ",");
            while (tokenizer.hasMoreElements()) {
                String item = tokenizer.nextToken().trim();
                list.add(MediaType.valueOf(item));
            }
        }
        MediaTypeHelper.sortByWeight(list);
        return list;
    }

    public List<Locale> getAcceptableLanguages() {
        ArrayList<Locale> list = new ArrayList<Locale>();
        Object accepts = this.headers.get("Accept-Language");
        if (accepts == null) {
            return list;
        }
        ArrayList<WeightedLanguage> languages = new ArrayList<WeightedLanguage>();
        Iterator iterator = accepts.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj instanceof Locale) {
                languages.add(new WeightedLanguage((Locale)obj, 1.0f));
                continue;
            }
            String accept = this.configuration.toHeaderString(obj);
            StringTokenizer tokenizer = new StringTokenizer(accept, ",");
            while (tokenizer.hasMoreElements()) {
                String item = tokenizer.nextToken().trim();
                languages.add(WeightedLanguage.parse(item));
            }
        }
        Collections.sort(languages);
        for (WeightedLanguage language : languages) {
            list.add(language.getLocale());
        }
        return list;
    }

    public Map<String, Cookie> getCookies() {
        HashMap<String, Cookie> cookies = new HashMap<String, Cookie>();
        Object list = this.headers.get("Cookie");
        if (list == null) {
            return cookies;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj instanceof Cookie) {
                Cookie cookie = (Cookie)obj;
                cookies.put(cookie.getName(), cookie);
                continue;
            }
            String str = this.configuration.toHeaderString(obj);
            Cookie cookie = Cookie.valueOf(str);
            cookies.put(cookie.getName(), cookie);
        }
        return cookies;
    }
}

