/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.authorization;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.AuthorizationContext;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.authorization.ClaimInformationPointProviderFactory;
import org.keycloak.adapters.authorization.PolicyEnforcer;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.authorization.client.ClientAuthorizationContext;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;
import org.keycloak.representations.idm.authorization.Permission;

public abstract class AbstractPolicyEnforcer {
    private static Logger LOGGER = Logger.getLogger(AbstractPolicyEnforcer.class);
    private static final String HTTP_METHOD_DELETE = "DELETE";
    private final PolicyEnforcer policyEnforcer;

    protected AbstractPolicyEnforcer(PolicyEnforcer policyEnforcer) {
        this.policyEnforcer = policyEnforcer;
    }

    public AuthorizationContext authorize(OIDCHttpFacade httpFacade) {
        PolicyEnforcerConfig.EnforcementMode enforcementMode = this.getEnforcerConfig().getEnforcementMode();
        if (PolicyEnforcerConfig.EnforcementMode.DISABLED.equals((Object)enforcementMode)) {
            return this.createEmptyAuthorizationContext(true);
        }
        HttpFacade.Request request = httpFacade.getRequest();
        PolicyEnforcerConfig.PathConfig pathConfig = this.getPathConfig(request);
        KeycloakSecurityContext securityContext = httpFacade.getSecurityContext();
        if (securityContext == null) {
            if (!this.isDefaultAccessDeniedUri(request)) {
                if (pathConfig != null) {
                    this.challenge(pathConfig, this.getRequiredScopes(pathConfig, request), httpFacade);
                } else {
                    this.handleAccessDenied(httpFacade);
                }
            }
            return this.createEmptyAuthorizationContext(false);
        }
        AccessToken accessToken = securityContext.getToken();
        if (accessToken != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debugf("Checking permissions for path [%s] with config [%s].", (Object)request.getURI(), (Object)pathConfig);
            }
            if (pathConfig == null) {
                if (PolicyEnforcerConfig.EnforcementMode.PERMISSIVE.equals((Object)enforcementMode)) {
                    return this.createAuthorizationContext(accessToken, null);
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debugf("Could not find a configuration for path [%s]", (Object)this.getPath(request));
                }
                if (this.isDefaultAccessDeniedUri(request)) {
                    return this.createAuthorizationContext(accessToken, null);
                }
                this.handleAccessDenied(httpFacade);
                return this.createEmptyAuthorizationContext(false);
            }
            if (PolicyEnforcerConfig.EnforcementMode.DISABLED.equals((Object)pathConfig.getEnforcementMode())) {
                return this.createAuthorizationContext(accessToken, pathConfig);
            }
            PolicyEnforcerConfig.MethodConfig methodConfig = this.getRequiredScopes(pathConfig, request);
            if (this.isAuthorized(pathConfig, methodConfig, accessToken, httpFacade)) {
                try {
                    return this.createAuthorizationContext(accessToken, pathConfig);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error processing path [" + pathConfig.getPath() + "].", e);
                }
            }
            if (methodConfig != null && PolicyEnforcerConfig.ScopeEnforcementMode.DISABLED.equals((Object)methodConfig.getScopesEnforcementMode())) {
                return this.createEmptyAuthorizationContext(true);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debugf("Sending challenge to the client. Path [%s]", (Object)pathConfig);
            }
            if (!this.challenge(pathConfig, methodConfig, httpFacade)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debugf("Challenge not sent, sending default forbidden response. Path [%s]", (Object)pathConfig);
                }
                this.handleAccessDenied(httpFacade);
            }
        }
        return this.createEmptyAuthorizationContext(false);
    }

    protected abstract boolean challenge(PolicyEnforcerConfig.PathConfig var1, PolicyEnforcerConfig.MethodConfig var2, OIDCHttpFacade var3);

    protected boolean isAuthorized(PolicyEnforcerConfig.PathConfig actualPathConfig, PolicyEnforcerConfig.MethodConfig methodConfig, AccessToken accessToken, OIDCHttpFacade httpFacade) {
        HttpFacade.Request request = httpFacade.getRequest();
        if (this.isDefaultAccessDeniedUri(request)) {
            return true;
        }
        AccessToken.Authorization authorization = accessToken.getAuthorization();
        if (authorization == null) {
            return false;
        }
        boolean hasPermission = false;
        Collection<Permission> grantedPermissions = authorization.getPermissions();
        for (Permission permission : grantedPermissions) {
            if (permission.getResourceId() != null) {
                if (!this.isResourcePermission(actualPathConfig, permission)) continue;
                hasPermission = true;
                if (actualPathConfig.isInstance() && !this.matchResourcePermission(actualPathConfig, permission) || !this.hasResourceScopePermission(methodConfig, permission)) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debugf("Authorization GRANTED for path [%s]. Permissions [%s].", (Object)actualPathConfig, (Object)grantedPermissions);
                }
                if (HTTP_METHOD_DELETE.equalsIgnoreCase(request.getMethod()) && actualPathConfig.isInstance()) {
                    this.policyEnforcer.getPathMatcher().removeFromCache(this.getPath(request));
                }
                return this.hasValidClaims(actualPathConfig, permission, httpFacade, authorization);
            }
            if (!this.hasResourceScopePermission(methodConfig, permission)) continue;
            hasPermission = true;
            return true;
        }
        if (!hasPermission && PolicyEnforcerConfig.EnforcementMode.PERMISSIVE.equals((Object)actualPathConfig.getEnforcementMode())) {
            return true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debugf("Authorization FAILED for path [%s]. Not enough permissions [%s].", (Object)actualPathConfig, (Object)grantedPermissions);
        }
        return false;
    }

    private boolean hasValidClaims(PolicyEnforcerConfig.PathConfig actualPathConfig, Permission permission, OIDCHttpFacade httpFacade, AccessToken.Authorization authorization) {
        Map<String, Set<String>> grantedClaims = permission.getClaims();
        if (grantedClaims != null) {
            Map<String, List<String>> claims = this.resolveClaims(actualPathConfig, httpFacade);
            if (claims.isEmpty()) {
                return false;
            }
            for (Map.Entry<String, Set<String>> entry : grantedClaims.entrySet()) {
                List<String> requestClaims = claims.get(entry.getKey());
                if (requestClaims != null && !requestClaims.isEmpty() && entry.getValue().containsAll(requestClaims)) continue;
                return false;
            }
        }
        return true;
    }

    protected void handleAccessDenied(OIDCHttpFacade httpFacade) {
        httpFacade.getResponse().sendError(403);
    }

    protected AuthzClient getAuthzClient() {
        return this.policyEnforcer.getClient();
    }

    protected PolicyEnforcerConfig getEnforcerConfig() {
        return this.policyEnforcer.getEnforcerConfig();
    }

    protected PolicyEnforcer getPolicyEnforcer() {
        return this.policyEnforcer;
    }

    private boolean isDefaultAccessDeniedUri(HttpFacade.Request request) {
        String accessDeniedPath = this.getEnforcerConfig().getOnDenyRedirectTo();
        return accessDeniedPath != null && request.getURI().contains(accessDeniedPath);
    }

    private boolean hasResourceScopePermission(PolicyEnforcerConfig.MethodConfig methodConfig, Permission permission) {
        List<String> requiredScopes = methodConfig.getScopes();
        Set<String> allowedScopes = permission.getScopes();
        if (allowedScopes.isEmpty()) {
            return true;
        }
        PolicyEnforcerConfig.ScopeEnforcementMode enforcementMode = methodConfig.getScopesEnforcementMode();
        if (PolicyEnforcerConfig.ScopeEnforcementMode.ALL.equals((Object)enforcementMode)) {
            return allowedScopes.containsAll(requiredScopes);
        }
        if (PolicyEnforcerConfig.ScopeEnforcementMode.ANY.equals((Object)enforcementMode)) {
            for (String requiredScope : requiredScopes) {
                if (!allowedScopes.contains(requiredScope)) continue;
                return true;
            }
        }
        return requiredScopes.isEmpty();
    }

    private AuthorizationContext createEmptyAuthorizationContext(final boolean granted) {
        return new ClientAuthorizationContext(this.getAuthzClient()){

            public boolean hasPermission(String resourceName, String scopeName) {
                return granted;
            }

            public boolean hasResourcePermission(String resourceName) {
                return granted;
            }

            public boolean hasScopePermission(String scopeName) {
                return granted;
            }

            public List<Permission> getPermissions() {
                return Collections.EMPTY_LIST;
            }

            public boolean isGranted() {
                return granted;
            }
        };
    }

    private String getPath(HttpFacade.Request request) {
        return request.getRelativePath();
    }

    private PolicyEnforcerConfig.MethodConfig getRequiredScopes(PolicyEnforcerConfig.PathConfig pathConfig, HttpFacade.Request request) {
        String method = request.getMethod();
        for (PolicyEnforcerConfig.MethodConfig methodConfig : pathConfig.getMethods()) {
            if (!methodConfig.getMethod().equals(method)) continue;
            return methodConfig;
        }
        PolicyEnforcerConfig.MethodConfig methodConfig = new PolicyEnforcerConfig.MethodConfig();
        methodConfig.setMethod(request.getMethod());
        methodConfig.setScopes(pathConfig.getScopes());
        methodConfig.setScopesEnforcementMode(PolicyEnforcerConfig.ScopeEnforcementMode.ANY);
        return methodConfig;
    }

    private AuthorizationContext createAuthorizationContext(AccessToken accessToken, PolicyEnforcerConfig.PathConfig pathConfig) {
        return new ClientAuthorizationContext(accessToken, pathConfig, this.getAuthzClient());
    }

    private boolean isResourcePermission(PolicyEnforcerConfig.PathConfig actualPathConfig, Permission permission) {
        boolean resourceMatch = this.matchResourcePermission(actualPathConfig, permission);
        if (!resourceMatch && actualPathConfig.isInstance()) {
            resourceMatch = this.matchResourcePermission(actualPathConfig.getParentConfig(), permission);
        }
        return resourceMatch;
    }

    private boolean matchResourcePermission(PolicyEnforcerConfig.PathConfig actualPathConfig, Permission permission) {
        return permission.getResourceId().equals(actualPathConfig.getId());
    }

    private PolicyEnforcerConfig.PathConfig getPathConfig(HttpFacade.Request request) {
        return this.isDefaultAccessDeniedUri(request) ? null : this.policyEnforcer.getPathMatcher().matches(this.getPath(request));
    }

    protected Map<String, List<String>> resolveClaims(PolicyEnforcerConfig.PathConfig pathConfig, OIDCHttpFacade httpFacade) {
        Map<String, List<String>> claims = this.getClaims(this.getEnforcerConfig().getClaimInformationPointConfig(), httpFacade);
        claims.putAll(this.getClaims(pathConfig.getClaimInformationPointConfig(), httpFacade));
        return claims;
    }

    private Map<String, List<String>> getClaims(Map<String, Map<String, Object>> claimInformationPointConfig, HttpFacade httpFacade) {
        HashMap<String, List<String>> claims = new HashMap<String, List<String>>();
        if (claimInformationPointConfig != null) {
            for (Map.Entry<String, Map<String, Object>> claimDef : claimInformationPointConfig.entrySet()) {
                ClaimInformationPointProviderFactory factory = this.getPolicyEnforcer().getClaimInformationPointProviderFactories().get(claimDef.getKey());
                if (factory == null) continue;
                claims.putAll(factory.create(claimDef.getValue()).resolve(httpFacade));
            }
        }
        return claims;
    }
}

