/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.authorization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.authorization.AbstractPolicyEnforcer;
import org.keycloak.adapters.authorization.PolicyEnforcer;
import org.keycloak.adapters.rotation.AdapterTokenVerifier;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.authorization.client.AuthorizationDeniedException;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.authorization.client.resource.PermissionResource;
import org.keycloak.authorization.client.resource.ProtectionResource;
import org.keycloak.common.util.Base64;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.representations.idm.authorization.AuthorizationResponse;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.representations.idm.authorization.PermissionRequest;
import org.keycloak.util.JsonSerialization;

public class KeycloakAdapterPolicyEnforcer
extends AbstractPolicyEnforcer {
    private static Logger LOGGER = Logger.getLogger(KeycloakAdapterPolicyEnforcer.class);

    public KeycloakAdapterPolicyEnforcer(PolicyEnforcer policyEnforcer) {
        super(policyEnforcer);
    }

    @Override
    protected boolean isAuthorized(PolicyEnforcerConfig.PathConfig pathConfig, PolicyEnforcerConfig.MethodConfig methodConfig, AccessToken accessToken, OIDCHttpFacade httpFacade, Map<String, List<String>> claims) {
        AccessToken.Authorization newAuthorization;
        AccessToken original = accessToken;
        if (super.isAuthorized(pathConfig, methodConfig, accessToken, httpFacade, claims)) {
            return true;
        }
        accessToken = this.requestAuthorizationToken(pathConfig, methodConfig, httpFacade, claims);
        if (accessToken == null) {
            return false;
        }
        AccessToken.Authorization authorization = original.getAuthorization();
        if (authorization == null) {
            authorization = new AccessToken.Authorization();
            authorization.setPermissions(new ArrayList<Permission>());
        }
        if ((newAuthorization = accessToken.getAuthorization()) != null) {
            Collection<Permission> grantedPermissions = authorization.getPermissions();
            Collection<Permission> newPermissions = newAuthorization.getPermissions();
            for (Permission newPermission : newPermissions) {
                if (grantedPermissions.contains(newPermission)) continue;
                grantedPermissions.add(newPermission);
            }
        }
        original.setAuthorization(authorization);
        return super.isAuthorized(pathConfig, methodConfig, accessToken, httpFacade, claims);
    }

    @Override
    protected boolean challenge(PolicyEnforcerConfig.PathConfig pathConfig, PolicyEnforcerConfig.MethodConfig methodConfig, OIDCHttpFacade httpFacade) {
        if (this.isBearerAuthorization(httpFacade)) {
            HttpFacade.Response response = httpFacade.getResponse();
            AuthzClient authzClient = this.getAuthzClient();
            String ticket = this.getPermissionTicket(pathConfig, methodConfig, authzClient, httpFacade);
            if (ticket != null) {
                response.setStatus(401);
                response.setHeader("WWW-Authenticate", "UMA realm=\"" + authzClient.getConfiguration().getRealm() + "\"" + ",as_uri=\"" + authzClient.getServerConfiguration().getIssuer() + "\"" + ",ticket=\"" + ticket + "\"");
            } else {
                response.setStatus(403);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Sending challenge");
            }
            return true;
        }
        this.handleAccessDenied(httpFacade);
        return true;
    }

    @Override
    protected void handleAccessDenied(OIDCHttpFacade facade) {
        String accessDeniedPath = this.getEnforcerConfig().getOnDenyRedirectTo();
        HttpFacade.Response response = facade.getResponse();
        if (accessDeniedPath != null) {
            response.setStatus(302);
            response.setHeader("Location", accessDeniedPath);
        } else {
            response.sendError(403);
        }
    }

    private AccessToken requestAuthorizationToken(PolicyEnforcerConfig.PathConfig pathConfig, PolicyEnforcerConfig.MethodConfig methodConfig, OIDCHttpFacade httpFacade, Map<String, List<String>> claims) {
        if (this.getEnforcerConfig().getUserManagedAccess() != null) {
            return null;
        }
        try {
            AuthorizationResponse authzResponse;
            KeycloakSecurityContext securityContext = httpFacade.getSecurityContext();
            String accessTokenString = securityContext.getTokenString();
            KeycloakDeployment deployment = this.getPolicyEnforcer().getDeployment();
            AccessToken accessToken = securityContext.getToken();
            AuthorizationRequest authzRequest = new AuthorizationRequest();
            if (this.isBearerAuthorization(httpFacade) || accessToken.getAuthorization() != null) {
                authzRequest.addPermission(pathConfig.getId(), methodConfig.getScopes());
            }
            if (!claims.isEmpty()) {
                authzRequest.setClaimTokenFormat("urn:ietf:params:oauth:token-type:jwt");
                authzRequest.setClaimToken(Base64.encodeBytes(JsonSerialization.writeValueAsBytes(claims)));
            }
            if (accessToken.getAuthorization() != null) {
                authzRequest.setRpt(accessTokenString);
            }
            LOGGER.debug("Obtaining authorization for authenticated user.");
            if (this.isBearerAuthorization(httpFacade)) {
                authzRequest.setSubjectToken(accessTokenString);
                authzResponse = this.getAuthzClient().authorization().authorize(authzRequest);
            } else {
                authzResponse = this.getAuthzClient().authorization(accessTokenString).authorize(authzRequest);
            }
            if (authzResponse != null) {
                return AdapterTokenVerifier.verifyToken(authzResponse.getToken(), deployment);
            }
        }
        catch (AuthorizationDeniedException ignore) {
            LOGGER.debug((Object)"Authorization denied", ignore);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error during authorization request.", e);
        }
        return null;
    }

    private String getPermissionTicket(PolicyEnforcerConfig.PathConfig pathConfig, PolicyEnforcerConfig.MethodConfig methodConfig, AuthzClient authzClient, OIDCHttpFacade httpFacade) {
        if (this.getEnforcerConfig().getUserManagedAccess() != null) {
            ProtectionResource protection = authzClient.protection();
            PermissionResource permission = protection.permission();
            PermissionRequest permissionRequest = new PermissionRequest();
            permissionRequest.setResourceId(pathConfig.getId());
            permissionRequest.setScopes(new HashSet<String>(methodConfig.getScopes()));
            Map<String, List<String>> claims = this.resolveClaims(pathConfig, httpFacade);
            if (!claims.isEmpty()) {
                permissionRequest.setClaims(claims);
            }
            return permission.create(permissionRequest).getTicket();
        }
        return null;
    }

    private boolean isBearerAuthorization(OIDCHttpFacade httpFacade) {
        List<String> authHeaders = httpFacade.getRequest().getHeaders("Authorization");
        if (authHeaders != null) {
            for (String authHeader : authHeaders) {
                String[] split = authHeader.trim().split("\\s+");
                if (split == null || split.length != 2 || !split[0].equalsIgnoreCase("Bearer")) continue;
                return true;
            }
        }
        return this.getPolicyEnforcer().getDeployment().isBearerOnly();
    }
}

