/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.authorization;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.jboss.logging.Logger;
import org.keycloak.AuthorizationContext;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.authentication.ClientCredentialsProviderUtils;
import org.keycloak.adapters.authorization.ClaimInformationPointProviderFactory;
import org.keycloak.adapters.authorization.KeycloakAdapterPolicyEnforcer;
import org.keycloak.adapters.authorization.PathCache;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.authorization.client.ClientAuthenticator;
import org.keycloak.authorization.client.Configuration;
import org.keycloak.authorization.client.resource.ProtectedResource;
import org.keycloak.common.util.PathMatcher;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;

public class PolicyEnforcer {
    private static Logger LOGGER = Logger.getLogger(PolicyEnforcer.class);
    private final KeycloakDeployment deployment;
    private final AuthzClient authzClient;
    private final PolicyEnforcerConfig enforcerConfig;
    private final PathConfigMatcher pathMatcher;
    private final Map<String, PolicyEnforcerConfig.PathConfig> paths;
    private final Map<String, ClaimInformationPointProviderFactory> claimInformationPointProviderFactories = new HashMap<String, ClaimInformationPointProviderFactory>();

    public PolicyEnforcer(KeycloakDeployment deployment, AdapterConfig adapterConfig) {
        this.deployment = deployment;
        this.enforcerConfig = adapterConfig.getPolicyEnforcerConfig();
        Configuration configuration = new Configuration(adapterConfig.getAuthServerUrl(), adapterConfig.getRealm(), adapterConfig.getResource(), adapterConfig.getCredentials(), deployment.getClient());
        this.authzClient = AuthzClient.create((Configuration)configuration, (ClientAuthenticator)new ClientAuthenticator(){

            public void configureClientCredentials(Map<String, List<String>> requestParams, Map<String, String> requestHeaders) {
                HashMap<String, String> formparams = new HashMap<String, String>();
                ClientCredentialsProviderUtils.setClientCredentials(PolicyEnforcer.this.deployment, requestHeaders, formparams);
                for (Map.Entry param : formparams.entrySet()) {
                    requestParams.put((String)param.getKey(), Arrays.asList((String)param.getValue()));
                }
            }
        });
        this.paths = this.configurePaths(this.authzClient.protection().resource(), this.enforcerConfig);
        this.pathMatcher = new PathConfigMatcher(this.paths, this.enforcerConfig, this.authzClient);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Initialization complete. Path configurations:");
            for (PolicyEnforcerConfig.PathConfig pathConfig : this.paths.values()) {
                LOGGER.debug(pathConfig);
            }
        }
        this.loadClaimInformationPointProviders(ServiceLoader.load(ClaimInformationPointProviderFactory.class, ClaimInformationPointProviderFactory.class.getClassLoader()));
        this.loadClaimInformationPointProviders(ServiceLoader.load(ClaimInformationPointProviderFactory.class, Thread.currentThread().getContextClassLoader()));
    }

    public AuthorizationContext enforce(OIDCHttpFacade facade) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debugv("Policy enforcement is enabled. Enforcing policy decisions for path [{0}].", (Object)facade.getRequest().getURI());
        }
        AuthorizationContext context = new KeycloakAdapterPolicyEnforcer(this).authorize(facade);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debugv("Policy enforcement result for path [{0}] is : {1}", (Object)facade.getRequest().getURI(), (Object)(context.isGranted() ? "GRANTED" : "DENIED"));
            LOGGER.debugv("Returning authorization context with permissions:", new Object[0]);
            for (Permission permission : context.getPermissions()) {
                LOGGER.debug(permission);
            }
        }
        return context;
    }

    public PolicyEnforcerConfig getEnforcerConfig() {
        return this.enforcerConfig;
    }

    public AuthzClient getClient() {
        return this.authzClient;
    }

    public Map<String, PolicyEnforcerConfig.PathConfig> getPaths() {
        return this.paths;
    }

    public PathConfigMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public KeycloakDeployment getDeployment() {
        return this.deployment;
    }

    public Map<String, ClaimInformationPointProviderFactory> getClaimInformationPointProviderFactories() {
        return this.claimInformationPointProviderFactories;
    }

    private void loadClaimInformationPointProviders(ServiceLoader<ClaimInformationPointProviderFactory> loader) {
        for (ClaimInformationPointProviderFactory factory : loader) {
            factory.init(this);
            this.claimInformationPointProviderFactories.put(factory.getName(), factory);
        }
    }

    private Map<String, PolicyEnforcerConfig.PathConfig> configurePaths(ProtectedResource protectedResource, PolicyEnforcerConfig enforcerConfig) {
        boolean loadPathsFromServer = enforcerConfig.getLazyLoadPaths() == false;
        for (PolicyEnforcerConfig.PathConfig pathConfig : enforcerConfig.getPaths()) {
            if (PolicyEnforcerConfig.EnforcementMode.DISABLED.equals((Object)pathConfig.getEnforcementMode())) continue;
            loadPathsFromServer = false;
            break;
        }
        if (loadPathsFromServer) {
            LOGGER.info("No path provided in configuration.");
            Map<String, PolicyEnforcerConfig.PathConfig> paths = this.configureAllPathsForResourceServer(protectedResource);
            paths.putAll(this.configureDefinedPaths(protectedResource, enforcerConfig));
            return paths;
        }
        LOGGER.info("Paths provided in configuration.");
        return this.configureDefinedPaths(protectedResource, enforcerConfig);
    }

    private Map<String, PolicyEnforcerConfig.PathConfig> configureDefinedPaths(ProtectedResource protectedResource, PolicyEnforcerConfig enforcerConfig) {
        Map<String, PolicyEnforcerConfig.PathConfig> paths = Collections.synchronizedMap(new LinkedHashMap());
        for (PolicyEnforcerConfig.PathConfig pathConfig : enforcerConfig.getPaths()) {
            ResourceRepresentation resource;
            String resourceName = pathConfig.getName();
            String path = pathConfig.getPath();
            if (resourceName != null) {
                LOGGER.debugf("Trying to find resource with name [%s] for path [%s].", (Object)resourceName, (Object)path);
                resource = protectedResource.findByName(resourceName);
            } else {
                LOGGER.debugf("Trying to find resource with uri [%s] for path [%s].", (Object)path, (Object)path);
                List resources = protectedResource.findByUri(path);
                if (resources.isEmpty()) {
                    resources = protectedResource.findByMatchingUri(path);
                }
                if (resources.size() == 1) {
                    resource = (ResourceRepresentation)resources.get(0);
                } else {
                    if (resources.size() > 1) {
                        throw new RuntimeException("Multiple resources found with the same uri");
                    }
                    resource = null;
                }
            }
            if (resource != null) {
                pathConfig.setId(resource.getId());
            }
            PolicyEnforcerConfig.PathConfig existingPath = null;
            for (PolicyEnforcerConfig.PathConfig current : paths.values()) {
                if (!current.getPath().equals(pathConfig.getPath())) continue;
                existingPath = current;
                break;
            }
            if (existingPath == null) {
                paths.put(pathConfig.getPath(), pathConfig);
                continue;
            }
            existingPath.getMethods().addAll(pathConfig.getMethods());
            existingPath.getScopes().addAll(pathConfig.getScopes());
        }
        return paths;
    }

    private Map<String, PolicyEnforcerConfig.PathConfig> configureAllPathsForResourceServer(ProtectedResource protectedResource) {
        LOGGER.info("Querying the server for all resources associated with this application.");
        Map<String, PolicyEnforcerConfig.PathConfig> paths = Collections.synchronizedMap(new HashMap());
        if (!this.enforcerConfig.getLazyLoadPaths().booleanValue()) {
            for (String id : protectedResource.findAll()) {
                ResourceRepresentation resourceDescription = protectedResource.findById(id);
                if (resourceDescription.getUris() == null || resourceDescription.getUris().isEmpty()) continue;
                for (PolicyEnforcerConfig.PathConfig pathConfig : PolicyEnforcerConfig.PathConfig.createPathConfigs(resourceDescription)) {
                    paths.put(pathConfig.getPath(), pathConfig);
                }
            }
        }
        return paths;
    }

    public class PathConfigMatcher
    extends PathMatcher<PolicyEnforcerConfig.PathConfig> {
        private final Map<String, PolicyEnforcerConfig.PathConfig> paths;
        private final PathCache pathCache;
        private final AuthzClient authzClient;
        private final PolicyEnforcerConfig enforcerConfig;

        public PathConfigMatcher(Map<String, PolicyEnforcerConfig.PathConfig> paths, PolicyEnforcerConfig enforcerConfig, AuthzClient authzClient) {
            this.paths = paths;
            this.enforcerConfig = enforcerConfig;
            PolicyEnforcerConfig.PathCacheConfig cacheConfig = enforcerConfig.getPathCacheConfig();
            if (cacheConfig == null) {
                cacheConfig = new PolicyEnforcerConfig.PathCacheConfig();
            }
            this.pathCache = new PathCache(cacheConfig.getMaxEntries(), cacheConfig.getLifespan());
            this.authzClient = authzClient;
        }

        @Override
        public PolicyEnforcerConfig.PathConfig matches(String targetUri) {
            PolicyEnforcerConfig.PathConfig pathConfig = this.pathCache.get(targetUri);
            if (this.pathCache.containsKey(targetUri) || pathConfig != null) {
                return pathConfig;
            }
            pathConfig = (PolicyEnforcerConfig.PathConfig)super.matches(targetUri);
            if ((this.enforcerConfig.getLazyLoadPaths().booleanValue() || this.enforcerConfig.getPathCacheConfig() != null) && (pathConfig == null || pathConfig.getPath().contains("*"))) {
                try {
                    List matchingResources = this.authzClient.protection().resource().findByMatchingUri(targetUri);
                    if (!matchingResources.isEmpty()) {
                        Map<String, Map<String, Object>> cipConfig = null;
                        if (pathConfig != null) {
                            cipConfig = pathConfig.getClaimInformationPointConfig();
                        }
                        pathConfig = PolicyEnforcerConfig.PathConfig.createPathConfigs((ResourceRepresentation)matchingResources.get(0)).iterator().next();
                        if (cipConfig != null) {
                            pathConfig.setClaimInformationPointConfig(cipConfig);
                        }
                    }
                }
                catch (Exception cause) {
                    LOGGER.errorf((Throwable)cause, "Could not lazy load resource with path [" + targetUri + "] from server", new Object[0]);
                    return null;
                }
            }
            this.pathCache.put(targetUri, pathConfig);
            return pathConfig;
        }

        @Override
        protected String getPath(PolicyEnforcerConfig.PathConfig entry) {
            return entry.getPath();
        }

        @Override
        protected Collection<PolicyEnforcerConfig.PathConfig> getPaths() {
            return this.paths.values();
        }

        public PathCache getPathCache() {
            return this.pathCache;
        }

        @Override
        protected PolicyEnforcerConfig.PathConfig resolvePathConfig(PolicyEnforcerConfig.PathConfig originalConfig, String path) {
            if (originalConfig.hasPattern()) {
                ProtectedResource resource = this.authzClient.protection().resource();
                List search = resource.findByUri(path);
                if (search.isEmpty()) {
                    search = resource.findByUri(this.buildUriFromTemplate(originalConfig.getPath(), path, true));
                }
                if (!search.isEmpty()) {
                    ResourceRepresentation targetResource = (ResourceRepresentation)search.get(0);
                    PolicyEnforcerConfig.PathConfig config = PolicyEnforcerConfig.PathConfig.createPathConfigs(targetResource).iterator().next();
                    config.setScopes(originalConfig.getScopes());
                    config.setMethods(originalConfig.getMethods());
                    config.setParentConfig(originalConfig);
                    config.setEnforcementMode(originalConfig.getEnforcementMode());
                    config.setClaimInformationPointConfig(originalConfig.getClaimInformationPointConfig());
                    return config;
                }
            }
            return null;
        }

        public void removeFromCache(String pathConfig) {
            this.pathCache.remove(pathConfig);
        }
    }
}

