/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.common.Version;

public class Profile {
    private static final Logger logger = Logger.getLogger(Profile.class);
    private static Profile CURRENT = new Profile();
    private final ProductValue product;
    private final ProfileValue profile;
    private final Set<Feature> disabledFeatures = new HashSet<Feature>();
    private final Set<Feature> previewFeatures = new HashSet<Feature>();
    private final Set<Feature> experimentalFeatures = new HashSet<Feature>();
    private final Set<Feature> deprecatedFeatures = new HashSet<Feature>();

    private Profile() {
        Config config = new Config();
        this.product = "rh-sso".equals(Version.NAME) ? ProductValue.RHSSO : ProductValue.KEYCLOAK;
        this.profile = ProfileValue.valueOf(config.getProfile().toUpperCase());
        block7: for (Feature f : Feature.values()) {
            Boolean enabled = config.getConfig(f);
            switch (f.getType()) {
                case DEFAULT: {
                    if (enabled == null || enabled.booleanValue()) continue block7;
                    this.disabledFeatures.add(f);
                    continue block7;
                }
                case DEPRECATED: {
                    this.deprecatedFeatures.add(f);
                }
                case DISABLED_BY_DEFAULT: {
                    if (enabled == null || !enabled.booleanValue()) {
                        this.disabledFeatures.add(f);
                        continue block7;
                    }
                    if (!Type.DEPRECATED.equals((Object)f.getType())) continue block7;
                    logger.warnf("Deprecated feature enabled: " + f.name().toLowerCase(), new Object[0]);
                    if (!Feature.UPLOAD_SCRIPTS.equals((Object)f)) continue block7;
                    this.previewFeatures.add(Feature.SCRIPTS);
                    this.disabledFeatures.remove((Object)Feature.SCRIPTS);
                    logger.warnf("Preview feature enabled: " + Feature.SCRIPTS.name().toLowerCase(), new Object[0]);
                    continue block7;
                }
                case PREVIEW: {
                    this.previewFeatures.add(f);
                    if (!(enabled != null && enabled.booleanValue() || this.profile.equals((Object)ProfileValue.PREVIEW))) {
                        this.disabledFeatures.add(f);
                        continue block7;
                    }
                    logger.info("Preview feature enabled: " + f.name().toLowerCase());
                    continue block7;
                }
                case EXPERIMENTAL: {
                    this.experimentalFeatures.add(f);
                    if (enabled == null || !enabled.booleanValue()) {
                        this.disabledFeatures.add(f);
                        continue block7;
                    }
                    logger.warn("Experimental feature enabled: " + f.name().toLowerCase());
                }
            }
        }
    }

    public static void init() {
        CURRENT = new Profile();
    }

    public static String getName() {
        return Profile.CURRENT.profile.name().toLowerCase();
    }

    public static Set<Feature> getDisabledFeatures() {
        return Profile.CURRENT.disabledFeatures;
    }

    public static Set<Feature> getPreviewFeatures() {
        return Profile.CURRENT.previewFeatures;
    }

    public static Set<Feature> getExperimentalFeatures() {
        return Profile.CURRENT.experimentalFeatures;
    }

    public static Set<Feature> getDeprecatedFeatures() {
        return Profile.CURRENT.deprecatedFeatures;
    }

    public static boolean isFeatureEnabled(Feature feature) {
        return !Profile.CURRENT.disabledFeatures.contains((Object)feature);
    }

    private class Config {
        private Properties properties = new Properties();

        public Config() {
            try {
                File file;
                String jbossServerConfigDir = System.getProperty("jboss.server.config.dir");
                if (jbossServerConfigDir != null && (file = new File(jbossServerConfigDir, "profile.properties")).isFile()) {
                    this.properties.load(new FileInputStream(file));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String getProfile() {
            String profile = System.getProperty("keycloak.profile");
            if (profile != null) {
                return profile;
            }
            profile = this.properties.getProperty("profile");
            if (profile != null) {
                return profile;
            }
            return Version.DEFAULT_PROFILE;
        }

        public Boolean getConfig(Feature feature) {
            String config = System.getProperty("keycloak.profile.feature." + feature.name().toLowerCase());
            if (config == null) {
                config = this.properties.getProperty("feature." + feature.name().toLowerCase());
            }
            if (config == null) {
                return null;
            }
            if (config.equals("enabled")) {
                return Boolean.TRUE;
            }
            if (config.equals("disabled")) {
                return Boolean.FALSE;
            }
            throw new RuntimeException("Invalid value for feature " + config);
        }
    }

    private static enum ProfileValue {
        COMMUNITY,
        PRODUCT,
        PREVIEW;

    }

    private static enum ProductValue {
        KEYCLOAK,
        RHSSO;

    }

    public static enum Feature {
        ACCOUNT2(Type.EXPERIMENTAL),
        ACCOUNT_API(Type.PREVIEW),
        ADMIN_FINE_GRAINED_AUTHZ(Type.PREVIEW),
        DOCKER(Type.DISABLED_BY_DEFAULT),
        IMPERSONATION(Type.DEFAULT),
        OPENSHIFT_INTEGRATION(Type.PREVIEW),
        SCRIPTS(Type.PREVIEW),
        TOKEN_EXCHANGE(Type.PREVIEW),
        UPLOAD_SCRIPTS(Type.DEPRECATED);

        private Type type;

        private Feature(Type type) {
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }
    }

    public static enum Type {
        DEFAULT,
        DISABLED_BY_DEFAULT,
        PREVIEW,
        EXPERIMENTAL,
        DEPRECATED;

    }
}

