/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.client.RxInvoker;
import javax.ws.rs.client.RxInvokerProvider;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.jboss.resteasy.client.jaxrs.internal.LocalResteasyProviderFactory;
import org.jboss.resteasy.core.ThreadLocalResteasyProviderFactory;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.HeaderValueProcessor;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class ClientConfiguration
implements Configuration,
Configurable<ClientConfiguration>,
Providers,
HeaderValueProcessor {
    protected ResteasyProviderFactory providerFactory;

    public ClientConfiguration(ResteasyProviderFactory factory) {
        this.providerFactory = factory instanceof ThreadLocalResteasyProviderFactory ? new LocalResteasyProviderFactory(((ThreadLocalResteasyProviderFactory)factory).getDelegate()) : new LocalResteasyProviderFactory(factory);
    }

    public ClientConfiguration(ClientConfiguration parent) {
        this(parent.getProviderFactory());
        this.setProperties(parent.getProperties());
    }

    public void setProperties(Map<String, Object> newProps) {
        this.providerFactory.setProperties(newProps);
    }

    protected ResteasyProviderFactory getProviderFactory() {
        return this.providerFactory;
    }

    public Map<String, Object> getMutableProperties() {
        return this.providerFactory.getMutableProperties();
    }

    @Override
    public String toHeaderString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        return this.providerFactory.toHeaderString(object);
    }

    @Override
    public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MessageBodyWriter<T> writer = this.providerFactory.getClientMessageBodyWriter(type, genericType, annotations, mediaType);
        if (writer != null) {
            LogMessages.LOGGER.debugf("MessageBodyWriter: %s", (Object)writer.getClass().getName());
        }
        return writer;
    }

    @Override
    public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MessageBodyReader<T> reader = this.providerFactory.getClientMessageBodyReader(type, genericType, annotations, mediaType);
        if (reader != null) {
            LogMessages.LOGGER.debugf("MessageBodyReader: %s", (Object)reader.getClass().getName());
        }
        return reader;
    }

    public WriterInterceptor[] getWriterInterceptors(Class declaring, AccessibleObject target) {
        return (WriterInterceptor[])this.providerFactory.getClientWriterInterceptorRegistry().postMatch(declaring, target);
    }

    public ReaderInterceptor[] getReaderInterceptors(Class declaring, AccessibleObject target) {
        return (ReaderInterceptor[])this.providerFactory.getClientReaderInterceptorRegistry().postMatch(declaring, target);
    }

    public ClientRequestFilter[] getRequestFilters(Class declaring, AccessibleObject target) {
        return (ClientRequestFilter[])this.providerFactory.getClientRequestFilterRegistry().postMatch(declaring, target);
    }

    public ClientResponseFilter[] getResponseFilters(Class declaring, AccessibleObject target) {
        return (ClientResponseFilter[])this.providerFactory.getClientResponseFilters().postMatch(declaring, target);
    }

    public Set<DynamicFeature> getDynamicFeatures() {
        return this.providerFactory.getClientDynamicFeatures();
    }

    public String toString(Object object) {
        return this.providerFactory.toString(object, object.getClass(), null, null);
    }

    @Override
    public <T extends Throwable> ExceptionMapper<T> getExceptionMapper(Class<T> type) {
        return this.providerFactory.getExceptionMapper(type);
    }

    @Override
    public <T> ContextResolver<T> getContextResolver(Class<T> contextType, MediaType mediaType) {
        return this.providerFactory.getContextResolver(contextType, mediaType);
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.providerFactory.getProperties();
    }

    @Override
    public Object getProperty(String name) {
        return this.providerFactory.getProperty(name);
    }

    @Override
    public Set<Class<?>> getClasses() {
        return this.providerFactory.getClasses();
    }

    @Override
    public Set<Object> getInstances() {
        return this.providerFactory.getInstances();
    }

    @Override
    public ClientConfiguration register(Class<?> providerClass) {
        this.providerFactory.register((Class)providerClass);
        return this;
    }

    @Override
    public ClientConfiguration register(Object provider) {
        this.providerFactory.register(provider);
        return this;
    }

    @Override
    public ClientConfiguration register(Class<?> providerClass, int priority) {
        this.providerFactory.register((Class)providerClass, priority);
        return this;
    }

    @Override
    public ClientConfiguration register(Object provider, int Priority2) {
        this.providerFactory.register(provider, Priority2);
        return this;
    }

    @Override
    public ClientConfiguration property(String name, Object value) {
        this.providerFactory.property(name, value);
        return this;
    }

    @Override
    public Configuration getConfiguration() {
        return this;
    }

    @Override
    public ClientConfiguration register(Class<?> componentClass, Class<?> ... contracts) {
        this.providerFactory.register((Class)componentClass, (Class[])contracts);
        return this;
    }

    @Override
    public ClientConfiguration register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.providerFactory.register((Class)componentClass, (Map)contracts);
        return this;
    }

    @Override
    public ClientConfiguration register(Object component, Class<?> ... contracts) {
        this.providerFactory.register(component, (Class[])contracts);
        return this;
    }

    @Override
    public ClientConfiguration register(Object component, Map<Class<?>, Integer> contracts) {
        this.providerFactory.register(component, (Map)contracts);
        return this;
    }

    @Override
    public RuntimeType getRuntimeType() {
        return RuntimeType.CLIENT;
    }

    @Override
    public Collection<String> getPropertyNames() {
        return this.providerFactory.getProperties().keySet();
    }

    @Override
    public boolean isEnabled(Feature feature) {
        return this.providerFactory.isEnabled(feature);
    }

    @Override
    public boolean isEnabled(Class<? extends Feature> featureClass) {
        return this.providerFactory.isEnabled(featureClass);
    }

    @Override
    public boolean isRegistered(Object component) {
        return this.providerFactory.isRegistered(component);
    }

    @Override
    public boolean isRegistered(Class<?> componentClass) {
        return this.providerFactory.isRegistered(componentClass);
    }

    @Override
    public Map<Class<?>, Integer> getContracts(Class<?> componentClass) {
        return this.providerFactory.getContracts(componentClass);
    }

    public <I extends RxInvoker<?>> RxInvokerProvider<I> getRxInvokerProvider(Class<I> clazz) {
        Map<Class<?>, Map<Class<?>, Integer>> classContracts = this.providerFactory.getClassContracts();
        for (Map.Entry<Class<?>, Map<Class<?>, Integer>> entry : classContracts.entrySet()) {
            RxInvokerProvider rip;
            if (!entry.getValue().containsKey(RxInvokerProvider.class) || !(rip = (RxInvokerProvider)this.providerFactory.createProviderInstance(entry.getKey())).isProviderFor(clazz)) continue;
            return rip;
        }
        return null;
    }

    public RxInvokerProvider<?> getRxInvokerProviderFromReactiveClass(Class<?> clazz) {
        return this.providerFactory.getRxInvokerProviderFromReactiveClass(clazz);
    }

    public boolean isReactive(Class<?> clazz) {
        return this.providerFactory.isReactive(clazz);
    }
}

